/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets;

import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Widget;

public class MarkupUtil {
    public static boolean isMarkupEnabledFor(Widget widget) {
        return Boolean.TRUE.equals(widget.getData("org.eclipse.rap.rwt.markupEnabled"));
    }

    public static boolean isToolTipMarkupEnabledFor(Widget widget) {
        return Boolean.TRUE.equals(widget.getData("org.eclipse.rap.rwt.tooltipMarkupEnabled"));
    }

    public static void checkMarkupPrecondition(String key, MarkupTarget target, MarkupPreconditionChecker checker) {
        String dataKeyName;
        String dataKey = MarkupTarget.TOOLTIP.equals((Object)target) ? "org.eclipse.rap.rwt.tooltipMarkupEnabled" : "org.eclipse.rap.rwt.markupEnabled";
        String string = dataKeyName = MarkupTarget.TOOLTIP.equals((Object)target) ? "RWT.TOOLTIP_MARKUP_ENABLED" : "RWT.MARKUP_ENABLED";
        if (dataKey.equals(key) && !checker.check()) {
            SWTException exception = new SWTException();
            String message = String.valueOf(dataKeyName) + " must be set before any widget data.";
            exception.throwable = new IllegalStateException(message);
            throw exception;
        }
    }

    private MarkupUtil() {
    }

    public static interface MarkupPreconditionChecker {
        public boolean check();
    }

    public static enum MarkupTarget {
        TEXT,
        TOOLTIP;

    }
}

