/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.custom.ccombokit;

import java.io.IOException;
import org.eclipse.rap.rwt.internal.lifecycle.ControlLCAUtil;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCA;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.internal.protocol.JsonUtil;
import org.eclipse.rap.rwt.internal.protocol.RemoteObjectFactory;
import org.eclipse.rap.rwt.remote.RemoteObject;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.custom.ccombokit.CComboOperationHandler;
import org.eclipse.swt.widgets.Widget;

public final class CComboLCA
extends WidgetLCA<CCombo> {
    public static final CComboLCA INSTANCE = new CComboLCA();
    private static final String TYPE = "rwt.widgets.Combo";
    private static final String[] ALLOWED_STYLES = new String[]{"FLAT", "BORDER"};
    static final String PROP_ITEMS = "items";
    static final String PROP_TEXT = "text";
    static final String PROP_SELECTION_INDEX = "selectionIndex";
    static final String PROP_SELECTION = "selection";
    static final String PROP_TEXT_LIMIT = "textLimit";
    static final String PROP_LIST_VISIBLE = "listVisible";
    static final String PROP_EDITABLE = "editable";
    static final String PROP_VISIBLE_ITEM_COUNT = "visibleItemCount";
    private static final String[] DEFAUT_ITEMS = new String[0];
    private static final Integer DEFAULT_SELECTION_INDEX = -1;
    private static final Point DEFAULT_SELECTION = new Point(0, 0);
    private static final int DEFAULT_VISIBLE_ITEM_COUNT = 5;

    @Override
    public void preserveValues(CCombo ccombo) {
        WidgetLCAUtil.preserveProperty((Widget)ccombo, PROP_ITEMS, ccombo.getItems());
        WidgetLCAUtil.preserveProperty((Widget)ccombo, PROP_SELECTION_INDEX, ccombo.getSelectionIndex());
        WidgetLCAUtil.preserveProperty((Widget)ccombo, PROP_SELECTION, ccombo.getSelection());
        WidgetLCAUtil.preserveProperty((Widget)ccombo, PROP_TEXT_LIMIT, CComboLCA.getTextLimit(ccombo));
        WidgetLCAUtil.preserveProperty((Widget)ccombo, PROP_VISIBLE_ITEM_COUNT, ccombo.getVisibleItemCount());
        WidgetLCAUtil.preserveProperty((Widget)ccombo, PROP_TEXT, ccombo.getText());
        WidgetLCAUtil.preserveProperty((Widget)ccombo, PROP_LIST_VISIBLE, ccombo.getListVisible());
        WidgetLCAUtil.preserveProperty((Widget)ccombo, PROP_EDITABLE, (Object)ccombo.getEditable());
    }

    @Override
    public void renderInitialization(CCombo ccombo) throws IOException {
        RemoteObject remoteObject = RemoteObjectFactory.createRemoteObject(ccombo, TYPE);
        remoteObject.setHandler(new CComboOperationHandler(ccombo));
        remoteObject.set("parent", WidgetUtil.getId(ccombo.getParent()));
        remoteObject.set("style", JsonUtil.createJsonArray(WidgetLCAUtil.getStyles(ccombo, ALLOWED_STYLES)));
        remoteObject.set("ccombo", true);
    }

    @Override
    public void renderChanges(CCombo ccombo) throws IOException {
        ControlLCAUtil.renderChanges(ccombo);
        WidgetLCAUtil.renderCustomVariant(ccombo);
        CComboLCA.renderVisibleItemCount(ccombo);
        CComboLCA.renderItems(ccombo);
        CComboLCA.renderListVisible(ccombo);
        CComboLCA.renderSelectionIndex(ccombo);
        CComboLCA.renderEditable(ccombo);
        CComboLCA.renderText(ccombo);
        CComboLCA.renderSelection(ccombo);
        CComboLCA.renderTextLimit(ccombo);
        WidgetLCAUtil.renderListenSelection(ccombo);
        WidgetLCAUtil.renderListenDefaultSelection(ccombo);
        WidgetLCAUtil.renderListenModifyVerify(ccombo);
    }

    private static void renderVisibleItemCount(CCombo ccombo) {
        int defValue = 5;
        WidgetLCAUtil.renderProperty((Widget)ccombo, PROP_VISIBLE_ITEM_COUNT, ccombo.getVisibleItemCount(), defValue);
    }

    private static void renderItems(CCombo ccombo) {
        WidgetLCAUtil.renderProperty((Widget)ccombo, PROP_ITEMS, ccombo.getItems(), DEFAUT_ITEMS);
    }

    private static void renderListVisible(CCombo ccombo) {
        WidgetLCAUtil.renderProperty((Widget)ccombo, PROP_LIST_VISIBLE, ccombo.getListVisible(), false);
    }

    private static void renderSelectionIndex(CCombo ccombo) {
        Integer newSelectionIndex = ccombo.getSelectionIndex();
        boolean selectionChanged = WidgetLCAUtil.hasChanged(ccombo, PROP_SELECTION_INDEX, newSelectionIndex, DEFAULT_SELECTION_INDEX);
        boolean itemsChanged = WidgetLCAUtil.hasChanged(ccombo, PROP_ITEMS, ccombo.getItems(), DEFAUT_ITEMS);
        boolean isInitialized = WidgetUtil.getAdapter(ccombo).isInitialized();
        if (selectionChanged || itemsChanged && isInitialized) {
            RemoteObjectFactory.getRemoteObject(ccombo).set(PROP_SELECTION_INDEX, newSelectionIndex);
        }
    }

    private static void renderEditable(CCombo ccombo) {
        WidgetLCAUtil.renderProperty((Widget)ccombo, PROP_EDITABLE, ccombo.getEditable(), true);
    }

    private static void renderText(CCombo ccombo) {
        WidgetLCAUtil.renderProperty((Widget)ccombo, PROP_TEXT, ccombo.getText(), "");
    }

    private static void renderSelection(CCombo ccombo) {
        WidgetLCAUtil.renderProperty((Widget)ccombo, PROP_SELECTION, ccombo.getSelection(), DEFAULT_SELECTION);
    }

    private static void renderTextLimit(CCombo ccombo) {
        WidgetLCAUtil.renderProperty((Widget)ccombo, PROP_TEXT_LIMIT, CComboLCA.getTextLimit(ccombo), null);
    }

    private static Integer getTextLimit(CCombo ccombo) {
        Integer result = ccombo.getTextLimit();
        if (result == Integer.MAX_VALUE) {
            result = null;
        }
        return result;
    }

    private CComboLCA() {
    }
}

