/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.client;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.client.service.ClientInfo;
import org.eclipse.rap.rwt.internal.remote.ConnectionImpl;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.remote.AbstractOperationHandler;
import org.eclipse.rap.rwt.remote.RemoteObject;

public class ClientInfoImpl
implements ClientInfo {
    private Integer timezoneOffset;
    private Locale[] locales;

    public ClientInfoImpl() {
        this.initialize();
    }

    private void initialize() {
        ConnectionImpl connection = (ConnectionImpl)RWT.getUISession().getConnection();
        RemoteObject remoteObject = connection.createServiceObject("rwt.client.ClientInfo");
        remoteObject.setHandler(new InfoOperationHandler());
        HttpServletRequest request = ContextProvider.getRequest();
        if (request.getHeader("Accept-Language") != null) {
            Enumeration locales = request.getLocales();
            this.locales = Collections.list(locales).toArray(new Locale[1]);
        }
    }

    @Override
    public int getTimezoneOffset() {
        if (this.timezoneOffset == null) {
            throw new IllegalStateException("timezoneOffset is not set");
        }
        return this.timezoneOffset;
    }

    @Override
    public Locale getLocale() {
        return this.locales == null ? null : this.locales[0];
    }

    @Override
    public Locale[] getLocales() {
        return this.locales == null ? new Locale[]{} : (Locale[])this.locales.clone();
    }

    private final class InfoOperationHandler
    extends AbstractOperationHandler {
        private InfoOperationHandler() {
        }

        @Override
        public void handleSet(JsonObject properties) {
            JsonValue value = properties.get("timezoneOffset");
            if (value != null) {
                ClientInfoImpl.this.timezoneOffset = value.asInt();
            }
        }
    }
}

