/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.RegionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.RegionsAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.analysis.PartialRegionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.analysis.PartialRegionClassAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.AbstractCyclicPartialRegionsAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.CyclicRegionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.TransformationPartitioner;
import org.eclipse.qvtd.compiler.internal.utilities.CompilerUtil;

public class CyclicRegionsAnalysis
extends AbstractCyclicPartialRegionsAnalysis<RegionsAnalysis> {
    private @Nullable Set<@NonNull CyclicRegionAnalysis> cyclicRegionsAnalyses = null;
    private @Nullable Set<@NonNull PartialRegionClassAnalysis<@NonNull RegionsAnalysis>> cyclicClassAnalyses = null;
    private @Nullable Map<@NonNull PartialRegionAnalysis<@NonNull RegionsAnalysis>, @NonNull CyclicRegionAnalysis> cyclicRegionAnalysis2smallestCyclicRegionsAnalysis = null;

    public CyclicRegionsAnalysis(@NonNull Iterable<@NonNull RegionAnalysis> regionAnalyses) {
        this.analyze(regionAnalyses);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void analyze(@NonNull Iterable<@NonNull RegionAnalysis> regionAnalyses) {
        HashMap<@NonNull HashSet<@NonNull PartialRegionAnalysis<@NonNull RegionsAnalysis>>, @NonNull CyclicRegionAnalysis> cyclicRegionAnalyses2cyclicRegionAnalysis = null;
        Map<@NonNull PartialRegionAnalysis<@NonNull PRA>, @NonNull Set<@NonNull PartialRegionAnalysis<@NonNull PRA>>> partitioner2predecessors = CompilerUtil.computeTransitivePredecessors(regionAnalyses, TransformationPartitioner.REGION_IMMEDIATE_PREDECESSORS, TransformationPartitioner.REGION_TRANSITIVE_PREDECESSORS);
        Map<@NonNull PartialRegionAnalysis<@NonNull PRA>, @NonNull Set<@NonNull PartialRegionAnalysis<@NonNull PRA>>> partitioner2successors = CompilerUtil.computeTransitiveSuccessors(partitioner2predecessors, TransformationPartitioner.REGION_TRANSITIVE_SUCCESSORS);
        for (PartialRegionAnalysis partialRegionAnalysis : regionAnalyses) {
            HashSet<@NonNull PartialRegionAnalysis<@NonNull RegionsAnalysis>> intersection = new HashSet<PartialRegionAnalysis<RegionsAnalysis>>(partitioner2predecessors.get(partialRegionAnalysis));
            intersection.retainAll(partitioner2successors.get(partialRegionAnalysis));
            if (intersection.isEmpty()) continue;
            if (cyclicRegionAnalyses2cyclicRegionAnalysis == null) {
                cyclicRegionAnalyses2cyclicRegionAnalysis = new HashMap<HashSet<PartialRegionAnalysis<RegionsAnalysis>>, CyclicRegionAnalysis>();
            }
            if (cyclicRegionAnalyses2cyclicRegionAnalysis.containsKey(intersection)) continue;
            cyclicRegionAnalyses2cyclicRegionAnalysis.put(intersection, new CyclicRegionAnalysis(intersection));
        }
        if (cyclicRegionAnalyses2cyclicRegionAnalysis == null) {
            return;
        }
        ArrayList<@NonNull V> arrayList = new ArrayList(cyclicRegionAnalyses2cyclicRegionAnalysis.values());
        if (arrayList.size() > 1) {
            Collections.sort(arrayList);
        }
        this.cyclicRegionAnalysis2smallestCyclicRegionsAnalysis = new HashMap<PartialRegionAnalysis<RegionsAnalysis>, CyclicRegionAnalysis>();
        HashMap<@NonNull PartialRegionAnalysis<@NonNull RegionsAnalysis>, @NonNull CyclicRegionAnalysis> cyclicRegionAnalysis2smallestCyclicRegionsAnalysis2 = this.cyclicRegionAnalysis2smallestCyclicRegionsAnalysis;
        for (CyclicRegionAnalysis cyclicRegionsAnalysis : arrayList) {
            for (PartialRegionAnalysis<RegionsAnalysis> cyclicRegionAnalysis : cyclicRegionsAnalysis.regionAnalyses) {
                if (cyclicRegionAnalysis2smallestCyclicRegionsAnalysis2.containsKey(cyclicRegionAnalysis)) continue;
                cyclicRegionAnalysis2smallestCyclicRegionsAnalysis2.put(cyclicRegionAnalysis, cyclicRegionsAnalysis);
            }
        }
        this.cyclicClassAnalyses = new HashSet<PartialRegionClassAnalysis<RegionsAnalysis>>();
        HashSet<@NonNull PartialRegionClassAnalysis<@NonNull RegionsAnalysis>> cyclicClassAnalyses2 = this.cyclicClassAnalyses;
        HashSet<@NonNull @NonNull E> consumedClassAnalyses = new HashSet();
        HashSet<@NonNull @NonNull E> superProducedClassAnalyses = new HashSet();
        for (PartialRegionAnalysis cyclicRegionAnalysis : cyclicRegionAnalysis2smallestCyclicRegionsAnalysis2.keySet()) {
            Iterable superProducedClassAnalyses2;
            Iterable<@NonNull PartialRegionClassAnalysis<@NonNull PRA>> consumedClassAnalyses2 = cyclicRegionAnalysis.getConsumedClassAnalyses();
            if (consumedClassAnalyses2 != null) {
                Iterables.addAll(consumedClassAnalyses, consumedClassAnalyses2);
            }
            if ((superProducedClassAnalyses2 = cyclicRegionAnalysis.getSuperProducedClassAnalyses()) == null) continue;
            Iterables.addAll(superProducedClassAnalyses, superProducedClassAnalyses2);
        }
        cyclicClassAnalyses2.addAll(consumedClassAnalyses);
        cyclicClassAnalyses2.retainAll(superProducedClassAnalyses);
        if (TransformationPartitioner.REGION_CYCLES.isActive()) {
            for (CyclicRegionAnalysis cyclicRegionsAnalysis : arrayList) {
                cyclicRegionsAnalysis.showCycle(TransformationPartitioner.REGION_CYCLES);
            }
        }
    }

    public @Nullable CyclicRegionAnalysis basicGetCyclicRegionAnalysis(@NonNull RegionAnalysis regionAnalysis) {
        return this.cyclicRegionAnalysis2smallestCyclicRegionsAnalysis != null ? this.cyclicRegionAnalysis2smallestCyclicRegionsAnalysis.get(regionAnalysis) : null;
    }

    public boolean isCyclic(@NonNull PartialRegionClassAnalysis<@NonNull RegionsAnalysis> classAnalysis) {
        return this.cyclicClassAnalyses != null ? this.cyclicClassAnalyses.contains(classAnalysis) : false;
    }
}

