/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvti;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public class NavigationEdgeSorter {
    protected final @NonNull Map<@NonNull NavigableEdge, @Nullable Set<@NonNull Node>> edge2sourceNodes = new HashMap<NavigableEdge, Set<Node>>();

    public static @NonNull Iterable<@NonNull NavigableEdge> getSortedAssignments(@NonNull Iterable<@NonNull NavigableEdge> realizedNavigationEdges) {
        NavigationEdgeSorter assignmentSorter = new NavigationEdgeSorter();
        for (NavigableEdge edge : realizedNavigationEdges) {
            if (edge.isSecondary()) continue;
            assignmentSorter.add(edge);
        }
        return assignmentSorter.getSortedAssignments();
    }

    public void add(@NonNull NavigableEdge navigationEdge) {
        Node targetNode;
        Set<@NonNull Node> sourceNodes = null;
        if (navigationEdge.isRealized() && (targetNode = navigationEdge.getEdgeTarget()).isDataType()) {
            sourceNodes = this.gatherSourceNodes(new HashSet<Node>(), targetNode);
        }
        this.edge2sourceNodes.put(navigationEdge, sourceNodes);
    }

    private @NonNull Set<@NonNull Node> gatherSourceNodes(@NonNull Set<@NonNull Node> sourceNodes, @NonNull Node node) {
        if (sourceNodes.add(node)) {
            for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)node)) {
                if (!edge.isComputation()) continue;
                this.gatherSourceNodes(sourceNodes, edge.getEdgeSource());
            }
        }
        return sourceNodes;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull Iterable<@NonNull NavigableEdge> getSortedAssignments() {
        @NonNull ArrayList sortedEdges = Lists.newArrayList(this.edge2sourceNodes.keySet());
        Collections.sort(sortedEdges, new SourceNodeSizeComparator());
        return sortedEdges;
    }

    public class SourceNodeSizeComparator
    implements Comparator<NavigableEdge> {
        @Override
        public int compare(@NonNull NavigableEdge o1, @NonNull NavigableEdge o2) {
            int i2;
            Set<@NonNull Node> s1 = NavigationEdgeSorter.this.edge2sourceNodes.get(o1);
            Set<@NonNull Node> s2 = NavigationEdgeSorter.this.edge2sourceNodes.get(o2);
            int i1 = s1 != null ? s1.size() : 0;
            int n = i2 = s2 != null ? s2.size() : 0;
            if (i1 != i2) {
                return i1 - i2;
            }
            String n1 = o1.toString();
            String n2 = o2.toString();
            return ClassUtil.safeCompareTo((Comparable)((Object)n1), (Comparable)((Object)n2));
        }
    }
}

