/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.proxy.runtime.client;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import org.eclipse.ptp.proxy.client.AbstractProxyClient;
import org.eclipse.ptp.proxy.command.IProxyCommand;
import org.eclipse.ptp.proxy.event.IProxyConnectedEvent;
import org.eclipse.ptp.proxy.event.IProxyDisconnectedEvent;
import org.eclipse.ptp.proxy.event.IProxyErrorEvent;
import org.eclipse.ptp.proxy.event.IProxyEvent;
import org.eclipse.ptp.proxy.event.IProxyEventListener;
import org.eclipse.ptp.proxy.event.IProxyExtendedEvent;
import org.eclipse.ptp.proxy.event.IProxyMessageEvent;
import org.eclipse.ptp.proxy.event.IProxyOKEvent;
import org.eclipse.ptp.proxy.event.IProxyTimeoutEvent;
import org.eclipse.ptp.proxy.messages.Messages;
import org.eclipse.ptp.proxy.runtime.client.IProxyRuntimeClient;
import org.eclipse.ptp.proxy.runtime.client.IProxyRuntimeEventListener;
import org.eclipse.ptp.proxy.runtime.command.IProxyRuntimeCommandFactory;
import org.eclipse.ptp.proxy.runtime.command.IProxyRuntimeFilterEventsCommand;
import org.eclipse.ptp.proxy.runtime.command.IProxyRuntimeStartEventsCommand;
import org.eclipse.ptp.proxy.runtime.command.IProxyRuntimeStopEventsCommand;
import org.eclipse.ptp.proxy.runtime.command.IProxyRuntimeSubmitJobCommand;
import org.eclipse.ptp.proxy.runtime.command.IProxyRuntimeTerminateJobCommand;
import org.eclipse.ptp.proxy.runtime.command.ProxyRuntimeCommandFactory;
import org.eclipse.ptp.proxy.runtime.event.IProxyRuntimeAttributeDefEvent;
import org.eclipse.ptp.proxy.runtime.event.IProxyRuntimeConnectedStateEvent;
import org.eclipse.ptp.proxy.runtime.event.IProxyRuntimeErrorStateEvent;
import org.eclipse.ptp.proxy.runtime.event.IProxyRuntimeEventFactory;
import org.eclipse.ptp.proxy.runtime.event.IProxyRuntimeJobChangeEvent;
import org.eclipse.ptp.proxy.runtime.event.IProxyRuntimeMachineChangeEvent;
import org.eclipse.ptp.proxy.runtime.event.IProxyRuntimeMessageEvent;
import org.eclipse.ptp.proxy.runtime.event.IProxyRuntimeNewJobEvent;
import org.eclipse.ptp.proxy.runtime.event.IProxyRuntimeNewMachineEvent;
import org.eclipse.ptp.proxy.runtime.event.IProxyRuntimeNewNodeEvent;
import org.eclipse.ptp.proxy.runtime.event.IProxyRuntimeNewProcessEvent;
import org.eclipse.ptp.proxy.runtime.event.IProxyRuntimeNewQueueEvent;
import org.eclipse.ptp.proxy.runtime.event.IProxyRuntimeNodeChangeEvent;
import org.eclipse.ptp.proxy.runtime.event.IProxyRuntimeProcessChangeEvent;
import org.eclipse.ptp.proxy.runtime.event.IProxyRuntimeQueueChangeEvent;
import org.eclipse.ptp.proxy.runtime.event.IProxyRuntimeRMChangeEvent;
import org.eclipse.ptp.proxy.runtime.event.IProxyRuntimeRemoveAllEvent;
import org.eclipse.ptp.proxy.runtime.event.IProxyRuntimeRemoveJobEvent;
import org.eclipse.ptp.proxy.runtime.event.IProxyRuntimeRemoveMachineEvent;
import org.eclipse.ptp.proxy.runtime.event.IProxyRuntimeRemoveNodeEvent;
import org.eclipse.ptp.proxy.runtime.event.IProxyRuntimeRemoveProcessEvent;
import org.eclipse.ptp.proxy.runtime.event.IProxyRuntimeRemoveQueueEvent;
import org.eclipse.ptp.proxy.runtime.event.IProxyRuntimeRunningStateEvent;
import org.eclipse.ptp.proxy.runtime.event.IProxyRuntimeShutdownStateEvent;
import org.eclipse.ptp.proxy.runtime.event.IProxyRuntimeStartupErrorEvent;
import org.eclipse.ptp.proxy.runtime.event.IProxyRuntimeSubmitJobErrorEvent;
import org.eclipse.ptp.proxy.runtime.event.IProxyRuntimeTerminateJobErrorEvent;
import org.eclipse.ptp.proxy.runtime.event.ProxyRuntimeEventFactory;

public abstract class AbstractProxyRuntimeClient
extends AbstractProxyClient
implements IProxyRuntimeClient,
IProxyEventListener {
    private boolean logEvents = false;
    private String proxyName = "";
    private volatile ProxyState state;
    private final List<IProxyCommand> commands = new ArrayList<IProxyCommand>();
    private final LinkedBlockingQueue<IProxyEvent> events = new LinkedBlockingQueue();
    private final Collection<IProxyRuntimeEventListener> listeners = Collections.synchronizedList(new ArrayList());
    protected final int baseModelId;
    protected final IProxyRuntimeEventFactory eventFactory;
    protected final IProxyRuntimeCommandFactory cmdFactory;

    public AbstractProxyRuntimeClient(String name, int baseModelId) {
        this(name, baseModelId, new ProxyRuntimeCommandFactory(), new ProxyRuntimeEventFactory());
    }

    public AbstractProxyRuntimeClient(String name, int baseModelId, IProxyRuntimeCommandFactory cmdFactory, IProxyRuntimeEventFactory eventFactory) {
        this.cmdFactory = cmdFactory;
        this.eventFactory = eventFactory;
        this.proxyName = name;
        this.baseModelId = baseModelId;
        this.state = ProxyState.IDLE;
        super.setEventFactory(eventFactory);
        super.addProxyEventListener(this);
        if (this.getDebugOptions().CLIENT_TRACING) {
            this.logEvents = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCommand(IProxyCommand command) {
        List<IProxyCommand> list = this.commands;
        synchronized (list) {
            this.commands.add(command);
        }
    }

    public void addProxyRuntimeEventListener(IProxyRuntimeEventListener listener) {
        this.listeners.add(listener);
    }

    public void filterEvents(String[] attrs) throws IOException {
        if (this.state != ProxyState.RUNNING) {
            throw new IOException(Messages.getString("AbstractProxyRuntimeClient_0"));
        }
        IProxyRuntimeFilterEventsCommand command = this.cmdFactory.newProxyRuntimeFilterEventsCommand(attrs);
        this.addCommand(command);
        this.sendCommand(command);
    }

    protected void fireProxyRuntimeAttributeDefEvent(IProxyRuntimeAttributeDefEvent event) {
        for (IProxyRuntimeEventListener listener : this.listeners) {
            listener.handleEvent(event);
        }
    }

    protected void fireProxyRuntimeConnectedStateEvent(IProxyRuntimeConnectedStateEvent event) {
        for (IProxyRuntimeEventListener listener : this.listeners) {
            listener.handleEvent(event);
        }
    }

    protected void fireProxyRuntimeErrorStateEvent(IProxyRuntimeErrorStateEvent event) {
        for (IProxyRuntimeEventListener listener : this.listeners) {
            listener.handleEvent(event);
        }
    }

    protected void fireProxyRuntimeJobChangeEvent(IProxyRuntimeJobChangeEvent event) {
        for (IProxyRuntimeEventListener listener : this.listeners) {
            listener.handleEvent(event);
        }
    }

    protected void fireProxyRuntimeMachineChangeEvent(IProxyRuntimeMachineChangeEvent event) {
        for (IProxyRuntimeEventListener listener : this.listeners) {
            listener.handleEvent(event);
        }
    }

    protected void fireProxyRuntimeMessageEvent(IProxyRuntimeMessageEvent event) {
        for (IProxyRuntimeEventListener listener : this.listeners) {
            listener.handleEvent(event);
        }
    }

    protected void fireProxyRuntimeNewJobEvent(IProxyRuntimeNewJobEvent event) {
        for (IProxyRuntimeEventListener listener : this.listeners) {
            listener.handleEvent(event);
        }
    }

    protected void fireProxyRuntimeNewMachineEvent(IProxyRuntimeNewMachineEvent event) {
        for (IProxyRuntimeEventListener listener : this.listeners) {
            listener.handleEvent(event);
        }
    }

    protected void fireProxyRuntimeNewNodeEvent(IProxyRuntimeNewNodeEvent event) {
        for (IProxyRuntimeEventListener listener : this.listeners) {
            listener.handleEvent(event);
        }
    }

    protected void fireProxyRuntimeNewProcessEvent(IProxyRuntimeNewProcessEvent event) {
        for (IProxyRuntimeEventListener listener : this.listeners) {
            listener.handleEvent(event);
        }
    }

    protected void fireProxyRuntimeNewQueueEvent(IProxyRuntimeNewQueueEvent event) {
        for (IProxyRuntimeEventListener listener : this.listeners) {
            listener.handleEvent(event);
        }
    }

    protected void fireProxyRuntimeNodeChangeEvent(IProxyRuntimeNodeChangeEvent event) {
        for (IProxyRuntimeEventListener listener : this.listeners) {
            listener.handleEvent(event);
        }
    }

    protected void fireProxyRuntimeProcessChangeEvent(IProxyRuntimeProcessChangeEvent event) {
        for (IProxyRuntimeEventListener listener : this.listeners) {
            listener.handleEvent(event);
        }
    }

    protected void fireProxyRuntimeQueueChangeEvent(IProxyRuntimeQueueChangeEvent event) {
        for (IProxyRuntimeEventListener listener : this.listeners) {
            listener.handleEvent(event);
        }
    }

    protected void fireProxyRuntimeRemoveAllEvent(IProxyRuntimeRemoveAllEvent event) {
        for (IProxyRuntimeEventListener listener : this.listeners) {
            listener.handleEvent(event);
        }
    }

    protected void fireProxyRuntimeRemoveJobEvent(IProxyRuntimeRemoveJobEvent event) {
        for (IProxyRuntimeEventListener listener : this.listeners) {
            listener.handleEvent(event);
        }
    }

    protected void fireProxyRuntimeRemoveMachineEvent(IProxyRuntimeRemoveMachineEvent event) {
        for (IProxyRuntimeEventListener listener : this.listeners) {
            listener.handleEvent(event);
        }
    }

    protected void fireProxyRuntimeRemoveNodeEvent(IProxyRuntimeRemoveNodeEvent event) {
        for (IProxyRuntimeEventListener listener : this.listeners) {
            listener.handleEvent(event);
        }
    }

    protected void fireProxyRuntimeRemoveProcessEvent(IProxyRuntimeRemoveProcessEvent event) {
        for (IProxyRuntimeEventListener listener : this.listeners) {
            listener.handleEvent(event);
        }
    }

    protected void fireProxyRuntimeRemoveQueueEvent(IProxyRuntimeRemoveQueueEvent event) {
        for (IProxyRuntimeEventListener listener : this.listeners) {
            listener.handleEvent(event);
        }
    }

    protected void fireProxyRuntimeRMChangeEvent(IProxyRuntimeRMChangeEvent event) {
        for (IProxyRuntimeEventListener listener : this.listeners) {
            listener.handleEvent(event);
        }
    }

    protected void fireProxyRuntimeRunningStateEvent(IProxyRuntimeRunningStateEvent event) {
        for (IProxyRuntimeEventListener listener : this.listeners) {
            listener.handleEvent(event);
        }
    }

    protected void fireProxyRuntimeShutdownStateEvent(IProxyRuntimeShutdownStateEvent event) {
        for (IProxyRuntimeEventListener listener : this.listeners) {
            listener.handleEvent(event);
        }
    }

    protected void fireProxyRuntimeStartupErrorEvent(IProxyRuntimeStartupErrorEvent event) {
        for (IProxyRuntimeEventListener listener : this.listeners) {
            listener.handleEvent(event);
        }
    }

    protected void fireProxyRuntimeSubmitJobErrorEvent(IProxyRuntimeSubmitJobErrorEvent event) {
        for (IProxyRuntimeEventListener listener : this.listeners) {
            listener.handleEvent(event);
        }
    }

    protected void fireProxyRuntimeTerminateJobErrorEvent(IProxyRuntimeTerminateJobErrorEvent event) {
        for (IProxyRuntimeEventListener listener : this.listeners) {
            listener.handleEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IProxyCommand getCommandForEvent(IProxyEvent event) {
        IProxyCommand[] ca;
        IProxyCommand command = null;
        List<IProxyCommand> list = this.commands;
        synchronized (list) {
            ca = this.commands.toArray(new IProxyCommand[0]);
        }
        IProxyCommand[] iProxyCommandArray = ca;
        int n = ca.length;
        int n2 = 0;
        while (n2 < n) {
            IProxyCommand cmd = iProxyCommandArray[n2];
            if (cmd.getTransactionID() == event.getTransactionID()) {
                command = cmd;
                break;
            }
            ++n2;
        }
        return command;
    }

    public void handleEvent(IProxyConnectedEvent event) {
        try {
            this.events.add(event);
        }
        catch (IllegalStateException except) {
            except.printStackTrace();
        }
    }

    public void handleEvent(IProxyDisconnectedEvent event) {
        try {
            this.events.add(event);
        }
        catch (IllegalStateException except) {
            except.printStackTrace();
        }
    }

    public void handleEvent(IProxyErrorEvent event) {
        try {
            this.events.add(event);
        }
        catch (IllegalStateException except) {
            except.printStackTrace();
        }
    }

    public void handleEvent(IProxyExtendedEvent event) {
        try {
            this.events.add(event);
        }
        catch (IllegalStateException except) {
            except.printStackTrace();
        }
    }

    public void handleEvent(IProxyMessageEvent event) {
        try {
            this.events.add(event);
        }
        catch (IllegalStateException except) {
            except.printStackTrace();
        }
    }

    public void handleEvent(IProxyOKEvent event) {
        try {
            this.events.add(event);
        }
        catch (IllegalStateException except) {
            except.printStackTrace();
        }
    }

    public void handleEvent(IProxyTimeoutEvent event) {
        try {
            this.events.add(event);
        }
        catch (IllegalStateException except) {
            except.printStackTrace();
        }
    }

    private void processRunningEvent(IProxyCommand command, IProxyEvent event) {
        if (this.logEvents) {
            System.out.println(String.valueOf(this.toString()) + " received event " + event);
        }
        if (event instanceof IProxyMessageEvent) {
            this.fireProxyRuntimeMessageEvent(this.eventFactory.newProxyRuntimeMessageEvent((IProxyMessageEvent)event));
        } else if (command instanceof IProxyRuntimeStartEventsCommand) {
            if (event instanceof IProxyRuntimeNewJobEvent) {
                this.fireProxyRuntimeNewJobEvent((IProxyRuntimeNewJobEvent)event);
            } else if (event instanceof IProxyRuntimeNewMachineEvent) {
                this.fireProxyRuntimeNewMachineEvent((IProxyRuntimeNewMachineEvent)event);
            } else if (event instanceof IProxyRuntimeNewNodeEvent) {
                this.fireProxyRuntimeNewNodeEvent((IProxyRuntimeNewNodeEvent)event);
            } else if (event instanceof IProxyRuntimeNewProcessEvent) {
                this.fireProxyRuntimeNewProcessEvent((IProxyRuntimeNewProcessEvent)event);
            } else if (event instanceof IProxyRuntimeNewQueueEvent) {
                this.fireProxyRuntimeNewQueueEvent((IProxyRuntimeNewQueueEvent)event);
            } else if (event instanceof IProxyRuntimeJobChangeEvent) {
                this.fireProxyRuntimeJobChangeEvent((IProxyRuntimeJobChangeEvent)event);
            } else if (event instanceof IProxyRuntimeMachineChangeEvent) {
                this.fireProxyRuntimeMachineChangeEvent((IProxyRuntimeMachineChangeEvent)event);
            } else if (event instanceof IProxyRuntimeNodeChangeEvent) {
                this.fireProxyRuntimeNodeChangeEvent((IProxyRuntimeNodeChangeEvent)event);
            } else if (event instanceof IProxyRuntimeProcessChangeEvent) {
                this.fireProxyRuntimeProcessChangeEvent((IProxyRuntimeProcessChangeEvent)event);
            } else if (event instanceof IProxyRuntimeQueueChangeEvent) {
                this.fireProxyRuntimeQueueChangeEvent((IProxyRuntimeQueueChangeEvent)event);
            } else if (event instanceof IProxyRuntimeRemoveAllEvent) {
                this.fireProxyRuntimeRemoveAllEvent((IProxyRuntimeRemoveAllEvent)event);
            } else if (event instanceof IProxyRuntimeRemoveJobEvent) {
                this.fireProxyRuntimeRemoveJobEvent((IProxyRuntimeRemoveJobEvent)event);
            } else if (event instanceof IProxyRuntimeRemoveMachineEvent) {
                this.fireProxyRuntimeRemoveMachineEvent((IProxyRuntimeRemoveMachineEvent)event);
            } else if (event instanceof IProxyRuntimeRemoveNodeEvent) {
                this.fireProxyRuntimeRemoveNodeEvent((IProxyRuntimeRemoveNodeEvent)event);
            } else if (event instanceof IProxyRuntimeRemoveProcessEvent) {
                this.fireProxyRuntimeRemoveProcessEvent((IProxyRuntimeRemoveProcessEvent)event);
            } else if (event instanceof IProxyRuntimeRemoveQueueEvent) {
                this.fireProxyRuntimeRemoveQueueEvent((IProxyRuntimeRemoveQueueEvent)event);
            } else if (event instanceof IProxyRuntimeRMChangeEvent) {
                this.fireProxyRuntimeRMChangeEvent((IProxyRuntimeRMChangeEvent)event);
            } else if (event instanceof IProxyErrorEvent) {
                this.fireProxyRuntimeErrorStateEvent(this.eventFactory.newProxyRuntimeErrorStateEvent());
            } else if (event instanceof IProxyOKEvent) {
                this.removeCommand(command);
            }
        } else if (command instanceof IProxyRuntimeStopEventsCommand) {
            this.removeCommand(command);
        } else if (command instanceof IProxyRuntimeFilterEventsCommand) {
            this.removeCommand(command);
        } else if (command instanceof IProxyRuntimeSubmitJobCommand) {
            if (event instanceof IProxyRuntimeSubmitJobErrorEvent) {
                this.fireProxyRuntimeSubmitJobErrorEvent(this.eventFactory.newProxyRuntimeSubmitJobErrorEvent(event.getTransactionID(), event.getAttributes()));
            } else if (event instanceof IProxyErrorEvent) {
                this.fireProxyRuntimeErrorStateEvent(this.eventFactory.newProxyRuntimeErrorStateEvent());
            }
            this.removeCommand(command);
        } else if (command instanceof IProxyRuntimeTerminateJobCommand) {
            if (event instanceof IProxyRuntimeTerminateJobErrorEvent) {
                this.fireProxyRuntimeTerminateJobErrorEvent(this.eventFactory.newProxyRuntimeTerminateJobErrorEvent(event.getTransactionID(), event.getAttributes()));
            } else if (event instanceof IProxyErrorEvent) {
                this.fireProxyRuntimeErrorStateEvent(this.eventFactory.newProxyRuntimeErrorStateEvent());
            }
            this.removeCommand(command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeCommand(IProxyCommand command) {
        List<IProxyCommand> list = this.commands;
        synchronized (list) {
            command.completed();
            this.commands.remove(command);
        }
    }

    public void removeProxyRuntimeEventListener(IProxyRuntimeEventListener listener) {
        this.listeners.remove(listener);
    }

    protected void runStateMachine() throws IOException, InterruptedException, IllegalStateException {
        block9: while (this.state != ProxyState.IDLE && this.state != ProxyState.ERROR) {
            switch (this.state) {
                case STARTUP: {
                    IProxyCommand command;
                    IProxyEvent event = this.events.take();
                    if (event instanceof IProxyConnectedEvent) {
                        try {
                            this.sessionHandleEvents();
                            command = this.cmdFactory.newProxyRuntimeInitCommand(this.baseModelId);
                            this.addCommand(command);
                            this.sendCommand(command);
                            this.state = ProxyState.INIT;
                            this.fireProxyRuntimeConnectedStateEvent(this.eventFactory.newProxyRuntimeConnectedStateEvent());
                        }
                        catch (IOException e) {
                            this.state = ProxyState.IDLE;
                            this.fireProxyRuntimeStartupErrorEvent(this.eventFactory.newProxyRuntimeStartupErrorEvent(e.getMessage()));
                        }
                        continue block9;
                    }
                    if (event instanceof IProxyTimeoutEvent) {
                        this.state = ProxyState.IDLE;
                        this.fireProxyRuntimeStartupErrorEvent(this.eventFactory.newProxyRuntimeStartupErrorEvent(Messages.getString("AbstractProxyRuntimeClient_1")));
                        break;
                    }
                    if (event instanceof IProxyDisconnectedEvent) {
                        this.state = ProxyState.IDLE;
                        this.fireProxyRuntimeStartupErrorEvent(this.eventFactory.newProxyRuntimeStartupErrorEvent(Messages.getString("AbstractProxyRuntimeClient_2")));
                        break;
                    }
                    this.state = ProxyState.ERROR;
                    this.fireProxyRuntimeErrorStateEvent(this.eventFactory.newProxyRuntimeErrorStateEvent());
                    throw new IllegalStateException(MessageFormat.format(Messages.getString("AbstractProxyRuntimeClient_3"), event.toString()));
                }
                case INIT: {
                    IProxyEvent event = this.events.take();
                    if (event instanceof IProxyDisconnectedEvent) {
                        this.state = ProxyState.IDLE;
                        this.fireProxyRuntimeStartupErrorEvent(this.eventFactory.newProxyRuntimeStartupErrorEvent(Messages.getString("AbstractProxyRuntimeClient_2")));
                        break;
                    }
                    if (event instanceof IProxyMessageEvent) {
                        this.fireProxyRuntimeMessageEvent(this.eventFactory.newProxyRuntimeMessageEvent((IProxyMessageEvent)event));
                        break;
                    }
                    IProxyCommand command = this.getCommandForEvent(event);
                    if (command != null) {
                        this.removeCommand(command);
                        if (event instanceof IProxyOKEvent) {
                            command = this.cmdFactory.newProxyRuntimeModelDefCommand();
                            this.addCommand(command);
                            this.sendCommand(command);
                            this.state = ProxyState.MODEL_DEF;
                            break;
                        }
                        if (event instanceof IProxyErrorEvent) {
                            this.state = ProxyState.IDLE;
                            this.fireProxyRuntimeStartupErrorEvent(this.eventFactory.newProxyRuntimeStartupErrorEvent(event.getAttributes()));
                            break;
                        }
                        this.state = ProxyState.ERROR;
                        this.fireProxyRuntimeErrorStateEvent(this.eventFactory.newProxyRuntimeErrorStateEvent());
                        throw new IllegalStateException(MessageFormat.format(Messages.getString("AbstractProxyRuntimeClient_4"), event.toString()));
                    }
                    this.state = ProxyState.ERROR;
                    this.fireProxyRuntimeErrorStateEvent(this.eventFactory.newProxyRuntimeErrorStateEvent());
                    throw new IllegalStateException(MessageFormat.format(Messages.getString("AbstractProxyRuntimeClient_5"), event.toString()));
                }
                case MODEL_DEF: {
                    IProxyEvent event = this.events.take();
                    if (event instanceof IProxyDisconnectedEvent) {
                        this.state = ProxyState.IDLE;
                        this.fireProxyRuntimeStartupErrorEvent(this.eventFactory.newProxyRuntimeStartupErrorEvent(Messages.getString("AbstractProxyRuntimeClient_2")));
                        break;
                    }
                    if (event instanceof IProxyMessageEvent) {
                        this.fireProxyRuntimeMessageEvent(this.eventFactory.newProxyRuntimeMessageEvent((IProxyMessageEvent)event));
                        break;
                    }
                    IProxyCommand command = this.getCommandForEvent(event);
                    if (command != null) {
                        if (event instanceof IProxyOKEvent) {
                            this.removeCommand(command);
                            this.state = ProxyState.RUNNING;
                            this.fireProxyRuntimeRunningStateEvent(this.eventFactory.newProxyRuntimeRunningStateEvent());
                            break;
                        }
                        if (event instanceof IProxyRuntimeAttributeDefEvent) {
                            this.fireProxyRuntimeAttributeDefEvent((IProxyRuntimeAttributeDefEvent)event);
                            break;
                        }
                        if (event instanceof IProxyErrorEvent) {
                            this.removeCommand(command);
                            this.state = ProxyState.IDLE;
                            this.fireProxyRuntimeStartupErrorEvent(this.eventFactory.newProxyRuntimeStartupErrorEvent(event.getAttributes()));
                            break;
                        }
                        this.removeCommand(command);
                        this.state = ProxyState.ERROR;
                        this.fireProxyRuntimeErrorStateEvent(this.eventFactory.newProxyRuntimeErrorStateEvent());
                        throw new IllegalStateException(MessageFormat.format(Messages.getString("AbstractProxyRuntimeClient_6"), event.toString()));
                    }
                    this.state = ProxyState.ERROR;
                    this.fireProxyRuntimeErrorStateEvent(this.eventFactory.newProxyRuntimeErrorStateEvent());
                    throw new IllegalStateException(MessageFormat.format(Messages.getString("AbstractProxyRuntimeClient_7"), event.toString()));
                }
                case RUNNING: {
                    IProxyEvent event = this.events.take();
                    if (event instanceof IProxyDisconnectedEvent) {
                        this.state = ProxyState.SHUTDOWN;
                        this.fireProxyRuntimeMessageEvent(this.eventFactory.newProxyRuntimeMessageEvent(IProxyMessageEvent.Level.FATAL, Messages.getString("AbstractProxyRuntimeClient_2")));
                        break;
                    }
                    IProxyCommand command = this.getCommandForEvent(event);
                    if (command != null) {
                        this.processRunningEvent(command, event);
                        break;
                    }
                    this.state = ProxyState.ERROR;
                    throw new IllegalStateException(MessageFormat.format(Messages.getString("AbstractProxyRuntimeClient_8"), event.toString()));
                }
                case SHUTDOWN: {
                    if (this.isShutdown()) {
                        this.fireProxyRuntimeShutdownStateEvent(this.eventFactory.newProxyRuntimeShutdownStateEvent());
                        this.state = ProxyState.IDLE;
                        this.commands.clear();
                        this.events.clear();
                        break;
                    }
                    this.events.take();
                    break;
                }
                default: {
                    throw new IllegalStateException(MessageFormat.format(Messages.getString("AbstractProxyRuntimeClient_9"), this.state.toString()));
                }
            }
        }
    }

    public void shutdown() throws IOException {
        if (this.state != ProxyState.SHUTDOWN) {
            if (this.logEvents) {
                System.out.println(String.valueOf(this.toString()) + ": shutting down server...");
            }
            this.state = ProxyState.SHUTDOWN;
        }
    }

    public void startEvents() throws IOException {
        if (this.state != ProxyState.RUNNING) {
            throw new IOException(Messages.getString("AbstractProxyRuntimeClient_0"));
        }
        IProxyRuntimeStartEventsCommand command = this.cmdFactory.newProxyRuntimeStartEventsCommand();
        this.addCommand(command);
        this.sendCommand(command);
    }

    public void startup() throws IOException {
        if (this.state == ProxyState.IDLE) {
            this.state = ProxyState.STARTUP;
            Thread smt = new Thread((Runnable)new StateMachineThread(), String.valueOf(this.proxyName) + "State Machine Thread");
            smt.start();
        }
    }

    public void stopEvents() throws IOException {
        if (this.state != ProxyState.RUNNING) {
            throw new IOException(Messages.getString("AbstractProxyRuntimeClient_0"));
        }
        IProxyRuntimeStopEventsCommand command = this.cmdFactory.newProxyRuntimeStopEventsCommand();
        this.addCommand(command);
        this.sendCommand(command);
    }

    public void submitJob(String[] attrs) throws IOException {
        if (this.state != ProxyState.RUNNING) {
            throw new IOException(Messages.getString("AbstractProxyRuntimeClient_0"));
        }
        IProxyRuntimeSubmitJobCommand command = this.cmdFactory.newProxyRuntimeSubmitJobCommand(attrs);
        this.addCommand(command);
        this.sendCommand(command);
    }

    public void terminateJob(String jobId) throws IOException {
        if (this.state != ProxyState.RUNNING) {
            throw new IOException(Messages.getString("AbstractProxyRuntimeClient_0"));
        }
        IProxyRuntimeTerminateJobCommand command = this.cmdFactory.newProxyRuntimeTerminateJobCommand(jobId);
        this.addCommand(command);
        this.sendCommand(command);
    }

    public String toString() {
        return String.valueOf(this.proxyName) + "ProxyRuntimeClient";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ProxyState {
        IDLE,
        STARTUP,
        INIT,
        MODEL_DEF,
        RUNNING,
        SHUTDOWN,
        END,
        ERROR;

    }

    private class StateMachineThread
    implements Runnable {
        private static final String name = "State Machine Thread";

        private StateMachineThread() {
        }

        public void run() {
            try {
                AbstractProxyRuntimeClient.this.runStateMachine();
            }
            catch (IllegalStateException e) {
                System.out.println("Illegal state detected: " + e.getMessage());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (AbstractProxyRuntimeClient.this.logEvents) {
                System.out.println("state machine thread exited");
            }
        }
    }
}

