/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.proxy.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import org.eclipse.ptp.internal.proxy.command.ProxyQuitCommand;
import org.eclipse.ptp.internal.proxy.event.ProxyConnectedEvent;
import org.eclipse.ptp.internal.proxy.event.ProxyDisconnectedEvent;
import org.eclipse.ptp.internal.proxy.event.ProxyMessageEvent;
import org.eclipse.ptp.internal.proxy.event.ProxyTimeoutEvent;
import org.eclipse.ptp.internal.proxy.runtime.command.ProxyRuntimeClearFiltersCommand;
import org.eclipse.ptp.internal.proxy.runtime.command.ProxyRuntimeResumeEventsCommand;
import org.eclipse.ptp.internal.proxy.runtime.command.ProxyRuntimeSetFiltersCommand;
import org.eclipse.ptp.internal.proxy.runtime.command.ProxyRuntimeSuspendEventsCommand;
import org.eclipse.ptp.proxy.client.IProxyClient;
import org.eclipse.ptp.proxy.client.ProxyEventQueue;
import org.eclipse.ptp.proxy.command.AbstractProxyCommand;
import org.eclipse.ptp.proxy.command.IProxyCommand;
import org.eclipse.ptp.proxy.event.IProxyConnectedEvent;
import org.eclipse.ptp.proxy.event.IProxyDisconnectedEvent;
import org.eclipse.ptp.proxy.event.IProxyErrorEvent;
import org.eclipse.ptp.proxy.event.IProxyEvent;
import org.eclipse.ptp.proxy.event.IProxyEventFactory;
import org.eclipse.ptp.proxy.event.IProxyEventListener;
import org.eclipse.ptp.proxy.event.IProxyExtendedEvent;
import org.eclipse.ptp.proxy.event.IProxyMessageEvent;
import org.eclipse.ptp.proxy.event.IProxyOKEvent;
import org.eclipse.ptp.proxy.event.IProxyShutdownEvent;
import org.eclipse.ptp.proxy.event.IProxyTimeoutEvent;
import org.eclipse.ptp.proxy.messages.Messages;
import org.eclipse.ptp.proxy.packet.ProxyPacket;
import org.eclipse.ptp.proxy.util.DebugOptions;
import org.eclipse.ptp.proxy.util.compression.IDecoder;
import org.eclipse.ptp.proxy.util.compression.IEncoder;
import org.eclipse.ptp.proxy.util.compression.huffmancoder.HuffmanByteCompress;
import org.eclipse.ptp.proxy.util.compression.huffmancoder.HuffmanByteUncompress;

public abstract class AbstractProxyClient
implements IProxyClient {
    private static final int LOW_EVENT_THRESHOLD = 0;
    private static final int HIGH_EVENT_THRESHOLD = 100;
    private static final int SHUTDOWN_THRESHOLD = 5000;
    private static final String[] stdioFilters = new String[]{"stdout", "stderr"};
    private int transactionID = 1;
    private int sessPort = 0;
    private ServerSocketChannel sessSvrSock = null;
    private SocketChannel sessSock = null;
    private IProxyEventFactory proxyEventFactory;
    private FlowControlState flowState = FlowControlState.NORMAL_FLOW;
    private final IEncoder compressor;
    private final IDecoder uncompressor;
    private Thread eventThread;
    private Thread acceptThread;
    private Thread packetThread;
    private volatile SessionState state;
    private ProxyEventQueue eventQueue;
    private final DebugOptions debugOptions;
    private final List<IProxyEventListener> listeners = Collections.synchronizedList(new ArrayList());
    private final Vector<AbstractProxyCommand> pendingCommands;

    public AbstractProxyClient() {
        this.debugOptions = new DebugOptions();
        this.state = SessionState.SHUTDOWN;
        this.pendingCommands = new Vector();
        this.compressor = new HuffmanByteCompress(ProxyPacket.getDefaultHuffmanTable());
        this.uncompressor = new HuffmanByteUncompress();
    }

    public void addProxyEventListener(IProxyEventListener listener) {
        this.listeners.add(listener);
    }

    protected void fireProxyConnectedEvent(IProxyConnectedEvent event) {
        IProxyEventListener[] la;
        IProxyEventListener[] iProxyEventListenerArray = la = this.listeners.toArray(new IProxyEventListener[0]);
        int n = la.length;
        int n2 = 0;
        while (n2 < n) {
            IProxyEventListener listener = iProxyEventListenerArray[n2];
            listener.handleEvent(event);
            ++n2;
        }
    }

    protected void fireProxyDisconnectedEvent(IProxyDisconnectedEvent event) {
        IProxyEventListener[] la;
        IProxyEventListener[] iProxyEventListenerArray = la = this.listeners.toArray(new IProxyEventListener[0]);
        int n = la.length;
        int n2 = 0;
        while (n2 < n) {
            IProxyEventListener listener = iProxyEventListenerArray[n2];
            listener.handleEvent(event);
            ++n2;
        }
    }

    protected void fireProxyErrorEvent(IProxyErrorEvent event) {
        IProxyEventListener[] la;
        IProxyEventListener[] iProxyEventListenerArray = la = this.listeners.toArray(new IProxyEventListener[0]);
        int n = la.length;
        int n2 = 0;
        while (n2 < n) {
            IProxyEventListener listener = iProxyEventListenerArray[n2];
            listener.handleEvent(event);
            ++n2;
        }
    }

    protected void fireProxyExtendedEvent(IProxyExtendedEvent event) {
        IProxyEventListener[] la;
        IProxyEventListener[] iProxyEventListenerArray = la = this.listeners.toArray(new IProxyEventListener[0]);
        int n = la.length;
        int n2 = 0;
        while (n2 < n) {
            IProxyEventListener listener = iProxyEventListenerArray[n2];
            listener.handleEvent(event);
            ++n2;
        }
    }

    protected void fireProxyMessageEvent(IProxyMessageEvent event) {
        IProxyEventListener[] la;
        IProxyEventListener[] iProxyEventListenerArray = la = this.listeners.toArray(new IProxyEventListener[0]);
        int n = la.length;
        int n2 = 0;
        while (n2 < n) {
            IProxyEventListener listener = iProxyEventListenerArray[n2];
            listener.handleEvent(event);
            ++n2;
        }
    }

    protected void fireProxyOKEvent(IProxyOKEvent event) {
        IProxyEventListener[] la;
        IProxyEventListener[] iProxyEventListenerArray = la = this.listeners.toArray(new IProxyEventListener[0]);
        int n = la.length;
        int n2 = 0;
        while (n2 < n) {
            IProxyEventListener listener = iProxyEventListenerArray[n2];
            listener.handleEvent(event);
            ++n2;
        }
    }

    protected void fireProxyTimeoutEvent(IProxyTimeoutEvent event) {
        IProxyEventListener[] la;
        IProxyEventListener[] iProxyEventListenerArray = la = this.listeners.toArray(new IProxyEventListener[0]);
        int n = la.length;
        int n2 = 0;
        while (n2 < n) {
            IProxyEventListener listener = iProxyEventListenerArray[n2];
            listener.handleEvent(event);
            ++n2;
        }
    }

    protected DebugOptions getDebugOptions() {
        return this.debugOptions;
    }

    public int getSessionPort() {
        return this.sessPort;
    }

    public boolean isReady() {
        return this.state == SessionState.RUNNING;
    }

    public boolean isShutdown() {
        return this.state == SessionState.SHUTDOWN;
    }

    public synchronized int newTransactionID() {
        return ++this.transactionID;
    }

    private boolean processPacket() throws IOException {
        ProxyPacket packet = new ProxyPacket(this.uncompressor);
        if (this.getDebugOptions().PROTOCOL_TRACING) {
            packet.setDebug(true);
        }
        if (!packet.read(this.sessSock)) {
            return false;
        }
        IProxyEvent e = this.proxyEventFactory.toEvent(packet);
        if (e != null) {
            this.eventQueue.addProxyEvent(e);
        }
        return true;
    }

    public void removeProxyEventListener(IProxyEventListener listener) {
        this.listeners.remove(listener);
    }

    private void runEventThread() throws IOException {
        this.eventThread = new Thread("Proxy Client Event Thread"){

            public void run() {
                int errorCount;
                boolean error;
                block9: {
                    error = false;
                    errorCount = 0;
                    if (AbstractProxyClient.this.getDebugOptions().CLIENT_TRACING) {
                        System.out.println("event thread starting...");
                    }
                    try {
                        while (errorCount < 5 && !this.isInterrupted()) {
                            if (AbstractProxyClient.this.state != SessionState.SHUTDOWN) {
                                if (AbstractProxyClient.this.sessionProgress()) continue;
                                ++errorCount;
                                continue;
                            }
                            break;
                        }
                    }
                    catch (IOException e) {
                        if (this.isInterrupted() || AbstractProxyClient.this.state == SessionState.SHUTTING_DOWN) break block9;
                        error = true;
                        if (!AbstractProxyClient.this.getDebugOptions().CLIENT_TRACING) break block9;
                        System.out.println("event thread IOException . . . " + e.getMessage());
                    }
                }
                if (errorCount >= 5) {
                    error = true;
                }
                try {
                    AbstractProxyClient.this.sessSock.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                AbstractProxyClient.this.state = SessionState.SHUTDOWN;
                AbstractProxyClient.this.fireProxyDisconnectedEvent(new ProxyDisconnectedEvent(error));
                if (AbstractProxyClient.this.getDebugOptions().CLIENT_TRACING) {
                    System.out.println("event thread exited");
                }
            }
        };
        if (this.state != SessionState.CONNECTED) {
            throw new IOException(Messages.getString("AbstractProxyClient_4"));
        }
        this.state = SessionState.RUNNING;
        this.eventThread.start();
    }

    private void runPacketThread() {
        this.packetThread = new Thread("Proxy Client Packet Thread"){

            public void run() {
                while (AbstractProxyClient.this.state != SessionState.SHUTDOWN) {
                    try {
                        if (AbstractProxyClient.this.processPacket()) continue;
                        AbstractProxyClient.this.eventQueue.addPriorityProxyEvent(new ProxyDisconnectedEvent(true));
                        AbstractProxyClient.this.state = SessionState.SHUTTING_DOWN;
                        AbstractProxyClient.this.eventQueue.addPriorityProxyEvent(AbstractProxyClient.this.proxyEventFactory.newShutdownEvent(0));
                    }
                    catch (IOException e) {
                        if (AbstractProxyClient.this.state == SessionState.SHUTTING_DOWN) {
                            AbstractProxyClient.this.eventQueue.addPriorityProxyEvent(AbstractProxyClient.this.proxyEventFactory.newShutdownEvent(0));
                            break;
                        }
                        AbstractProxyClient.this.eventQueue.addPriorityProxyEvent(AbstractProxyClient.this.proxyEventFactory.newErrorEvent(0, new String[]{e.getLocalizedMessage()}));
                        break;
                    }
                }
            }
        };
        this.packetThread.start();
    }

    private void sendClearFiltersCommand(String[] args) {
        try {
            ProxyRuntimeClearFiltersCommand cmd = new ProxyRuntimeClearFiltersCommand();
            int i = 0;
            while (i < args.length) {
                cmd.addArgument(args[i]);
                ++i;
            }
            this.sendCommand(cmd);
            this.pendingCommands.add(cmd);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void sendCommand(IProxyCommand cmd) throws IOException {
        if (!this.isReady()) {
            throw new IOException(Messages.getString("AbstractProxyClient_0"));
        }
        ProxyPacket packet = new ProxyPacket(cmd, this.compressor);
        if (this.getDebugOptions().PROTOCOL_TRACING) {
            packet.setDebug(true);
        }
        packet.send(this.sessSock);
    }

    private void sendResumeEventsCommand() {
        try {
            ProxyRuntimeResumeEventsCommand cmd = new ProxyRuntimeResumeEventsCommand();
            this.sendCommand(cmd);
            this.pendingCommands.add(cmd);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void sendSetFiltersCommand(String[] args) {
        try {
            ProxyRuntimeSetFiltersCommand cmd = new ProxyRuntimeSetFiltersCommand();
            int i = 0;
            while (i < args.length) {
                cmd.addArgument(args[i]);
                ++i;
            }
            this.sendCommand(cmd);
            this.pendingCommands.add(cmd);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void sendShutdownServerCommand() {
        try {
            ProxyQuitCommand cmd = new ProxyQuitCommand();
            this.sendCommand(cmd);
            this.pendingCommands.add(cmd);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void sendSuspendEventsCommand() {
        try {
            ProxyRuntimeSuspendEventsCommand cmd = new ProxyRuntimeSuspendEventsCommand();
            this.sendCommand(cmd);
            this.pendingCommands.add(cmd);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int sessionConnect() {
        return 0;
    }

    public void sessionCreate() throws IOException {
        this.sessionCreate(0);
    }

    public void sessionCreate(int timeout) throws IOException {
        this.sessionCreate(0, timeout);
    }

    public void sessionCreate(int port, int timeout) throws IOException {
        if (this.getDebugOptions().CLIENT_TRACING) {
            System.out.println("sessionCreate(" + port + "," + timeout + ")");
        }
        this.sessSvrSock = ServerSocketChannel.open();
        InetSocketAddress isa = new InetSocketAddress(port);
        if (this.getDebugOptions().CLIENT_TRACING) {
            System.out.println("bind(" + isa.toString() + ")");
        }
        this.sessSvrSock.socket().bind(isa);
        if (timeout > 0) {
            this.sessSvrSock.socket().setSoTimeout(timeout);
        }
        this.sessPort = this.sessSvrSock.socket().getLocalPort();
        this.state = SessionState.WAITING;
        if (this.getDebugOptions().CLIENT_TRACING) {
            System.out.println("port=" + this.sessPort);
        }
        this.acceptThread = new Thread("Proxy Client Accept Thread"){

            /*
             * Loose catch block
             */
            public void run() {
                boolean error = false;
                try {
                    try {
                        if (AbstractProxyClient.this.getDebugOptions().CLIENT_TRACING) {
                            System.out.println("accept thread starting...");
                        }
                        AbstractProxyClient.this.sessSock = AbstractProxyClient.this.sessSvrSock.accept();
                    }
                    catch (SocketTimeoutException e) {
                        block37: {
                            error = true;
                            AbstractProxyClient.this.fireProxyTimeoutEvent(new ProxyTimeoutEvent());
                            try {
                                AbstractProxyClient.this.sessSvrSock.close();
                            }
                            catch (IOException e2) {
                                if (!AbstractProxyClient.this.getDebugOptions().CLIENT_TRACING) break block37;
                                System.out.println("IO Exception trying to close server socket (non fatal)");
                            }
                        }
                        if (this.isInterrupted()) {
                            error = true;
                            AbstractProxyClient.this.fireProxyMessageEvent(new ProxyMessageEvent(IProxyMessageEvent.Level.WARNING, Messages.getString("AbstractProxyClient_3")));
                        }
                        if (!error && AbstractProxyClient.this.state == SessionState.WAITING) {
                            AbstractProxyClient.this.state = SessionState.CONNECTED;
                            AbstractProxyClient.this.fireProxyConnectedEvent(new ProxyConnectedEvent());
                        } else {
                            AbstractProxyClient.this.state = SessionState.SHUTDOWN;
                        }
                        if (AbstractProxyClient.this.getDebugOptions().CLIENT_TRACING) {
                            System.out.println("accept thread exiting...");
                        }
                    }
                    catch (ClosedByInterruptException e) {
                        block38: {
                            error = true;
                            AbstractProxyClient.this.fireProxyMessageEvent(new ProxyMessageEvent(IProxyMessageEvent.Level.WARNING, Messages.getString("AbstractProxyClient_1")));
                            try {
                                AbstractProxyClient.this.sessSvrSock.close();
                            }
                            catch (IOException e3) {
                                if (!AbstractProxyClient.this.getDebugOptions().CLIENT_TRACING) break block38;
                                System.out.println("IO Exception trying to close server socket (non fatal)");
                            }
                        }
                        if (this.isInterrupted()) {
                            error = true;
                            AbstractProxyClient.this.fireProxyMessageEvent(new ProxyMessageEvent(IProxyMessageEvent.Level.WARNING, Messages.getString("AbstractProxyClient_3")));
                        }
                        if (!error && AbstractProxyClient.this.state == SessionState.WAITING) {
                            AbstractProxyClient.this.state = SessionState.CONNECTED;
                            AbstractProxyClient.this.fireProxyConnectedEvent(new ProxyConnectedEvent());
                        } else {
                            AbstractProxyClient.this.state = SessionState.SHUTDOWN;
                        }
                        if (AbstractProxyClient.this.getDebugOptions().CLIENT_TRACING) {
                            System.out.println("accept thread exiting...");
                        }
                    }
                    catch (IOException e) {
                        block39: {
                            error = true;
                            AbstractProxyClient.this.fireProxyMessageEvent(new ProxyMessageEvent(IProxyMessageEvent.Level.FATAL, Messages.getString("AbstractProxyClient_2")));
                            {
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                            }
                            try {
                                AbstractProxyClient.this.sessSvrSock.close();
                            }
                            catch (IOException e4) {
                                if (!AbstractProxyClient.this.getDebugOptions().CLIENT_TRACING) break block39;
                                System.out.println("IO Exception trying to close server socket (non fatal)");
                            }
                        }
                        if (this.isInterrupted()) {
                            error = true;
                            AbstractProxyClient.this.fireProxyMessageEvent(new ProxyMessageEvent(IProxyMessageEvent.Level.WARNING, Messages.getString("AbstractProxyClient_3")));
                        }
                        if (!error && AbstractProxyClient.this.state == SessionState.WAITING) {
                            AbstractProxyClient.this.state = SessionState.CONNECTED;
                            AbstractProxyClient.this.fireProxyConnectedEvent(new ProxyConnectedEvent());
                        } else {
                            AbstractProxyClient.this.state = SessionState.SHUTDOWN;
                        }
                        if (AbstractProxyClient.this.getDebugOptions().CLIENT_TRACING) {
                            System.out.println("accept thread exiting...");
                        }
                    }
                }
                finally {
                    block40: {
                        try {
                            AbstractProxyClient.this.sessSvrSock.close();
                        }
                        catch (IOException e) {
                            if (!AbstractProxyClient.this.getDebugOptions().CLIENT_TRACING) break block40;
                            System.out.println("IO Exception trying to close server socket (non fatal)");
                        }
                    }
                    if (this.isInterrupted()) {
                        error = true;
                        AbstractProxyClient.this.fireProxyMessageEvent(new ProxyMessageEvent(IProxyMessageEvent.Level.WARNING, Messages.getString("AbstractProxyClient_3")));
                    }
                    if (!error && AbstractProxyClient.this.state == SessionState.WAITING) {
                        AbstractProxyClient.this.state = SessionState.CONNECTED;
                        AbstractProxyClient.this.fireProxyConnectedEvent(new ProxyConnectedEvent());
                    } else {
                        AbstractProxyClient.this.state = SessionState.SHUTDOWN;
                    }
                    if (AbstractProxyClient.this.getDebugOptions().CLIENT_TRACING) {
                        System.out.println("accept thread exiting...");
                    }
                }
            }
        };
        this.acceptThread.start();
    }

    public void sessionFinish() throws IOException {
        switch (this.state) {
            case WAITING: {
                if (this.acceptThread.isAlive()) {
                    this.acceptThread.interrupt();
                }
                this.state = SessionState.SHUTTING_DOWN;
                break;
            }
            case CONNECTED: {
                try {
                    this.sessSock.close();
                    this.state = SessionState.SHUTTING_DOWN;
                }
                catch (IOException e) {
                    this.state = SessionState.SHUTDOWN;
                }
                break;
            }
            case RUNNING: {
                ProxyQuitCommand cmd = new ProxyQuitCommand();
                try {
                    this.sendCommand(cmd);
                    this.state = SessionState.SHUTTING_DOWN;
                }
                catch (IOException e) {
                    this.state = SessionState.SHUTDOWN;
                }
                break;
            }
            case SHUTDOWN: {
                break;
            }
        }
    }

    public void sessionHandleEvents() throws IOException {
        this.eventQueue = new ProxyEventQueue();
        this.runEventThread();
        this.runPacketThread();
    }

    private boolean sessionProgress() throws IOException {
        IProxyEvent e;
        int queueSize = this.eventQueue.size();
        if (queueSize >= 5000) {
            if (this.flowState != FlowControlState.TERMINATE_FLOW) {
                this.sendShutdownServerCommand();
                this.flowState = FlowControlState.TERMINATE_FLOW;
            }
        } else if (queueSize >= 100) {
            if (this.flowState != FlowControlState.SUSPEND_FLOW) {
                this.sendSuspendEventsCommand();
                this.sendSetFiltersCommand(stdioFilters);
                this.flowState = FlowControlState.SUSPEND_FLOW;
            }
        } else if (queueSize <= 0 && this.flowState != FlowControlState.NORMAL_FLOW) {
            this.sendResumeEventsCommand();
            this.sendClearFiltersCommand(stdioFilters);
            this.flowState = FlowControlState.NORMAL_FLOW;
        }
        if ((e = this.eventQueue.getProxyEvent()) != null) {
            if (e instanceof IProxyMessageEvent) {
                this.fireProxyMessageEvent((IProxyMessageEvent)e);
            } else if (e instanceof IProxyOKEvent) {
                AbstractProxyCommand matchingCommand = null;
                for (AbstractProxyCommand cmd : this.pendingCommands) {
                    if (cmd.getTransactionID() != e.getTransactionID()) continue;
                    matchingCommand = cmd;
                    break;
                }
                if (matchingCommand == null) {
                    this.fireProxyOKEvent((IProxyOKEvent)e);
                } else {
                    this.pendingCommands.remove(matchingCommand);
                }
            } else if (e instanceof IProxyErrorEvent) {
                this.fireProxyErrorEvent((IProxyErrorEvent)e);
            } else if (e instanceof IProxyShutdownEvent) {
                if (this.state == SessionState.SHUTTING_DOWN) {
                    this.state = SessionState.SHUTDOWN;
                }
            } else if (e instanceof IProxyExtendedEvent) {
                this.fireProxyExtendedEvent((IProxyExtendedEvent)e);
            }
            return true;
        }
        return false;
    }

    public void setEventFactory(IProxyEventFactory factory) {
        this.proxyEventFactory = factory;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum FlowControlState {
        NORMAL_FLOW,
        SUSPEND_FLOW,
        TERMINATE_FLOW;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SessionState {
        WAITING,
        CONNECTED,
        RUNNING,
        SHUTTING_DOWN,
        SHUTDOWN;

    }
}

