/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.openmp.analysis.ompcfg.factory;

import java.io.PrintStream;
import java.util.Set;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.ptp.pldt.openmp.analysis.ompcfg.OMPCFG;
import org.eclipse.ptp.pldt.openmp.analysis.ompcfg.factory.FunctionConcurrencyAnalysis;
import org.eclipse.ptp.pldt.openmp.analysis.ompcfg.factory.PASTSemanticCheck;
import org.eclipse.ptp.pldt.openmp.analysis.ompcfg.factory.PhaseAnalysisFactory;
import org.eclipse.ptp.pldt.openmp.analysis.ompcfg.factory.PhaseConcurrencyAnalysis;
import org.eclipse.ptp.pldt.openmp.analysis.ompcfg.factory.RegionConcurrencyMap;

public class RegionConcurrencyAnalysis {
    protected FunctionConcurrencyAnalysis analysis_ = null;
    protected OMPCFG cfg_ = null;
    protected PhaseConcurrencyAnalysis[] phases_ = null;
    protected RegionConcurrencyMap cMap_ = null;

    public RegionConcurrencyAnalysis(OMPCFG cfg) {
        this.cfg_ = cfg;
        this.semanticCheck();
    }

    public void setParent(FunctionConcurrencyAnalysis analysis) {
        this.analysis_ = analysis;
    }

    public OMPCFG getCFG() {
        return this.cfg_;
    }

    public PhaseConcurrencyAnalysis[] getPhases() {
        return this.phases_;
    }

    public void doPhaseAnalysis() {
        PhaseAnalysisFactory paf = new PhaseAnalysisFactory(this.cfg_);
        paf.buildPhases();
        this.phases_ = paf.getPhases();
        this.cMap_ = new RegionConcurrencyMap(this);
        this.cMap_.buildMap();
    }

    public Set getNodesConcurrentTo(IASTNode node) {
        return this.cMap_.getNodesConcurrentTo(node);
    }

    public void printComponent(PrintStream ps) {
        int i = 0;
        while (i < this.phases_.length) {
            ps.println("Component Phase " + i + " ----------------------------------");
            this.phases_[i].printPhase(ps);
            ++i;
        }
    }

    private void semanticCheck() {
        PASTSemanticCheck.checkSemantics(this.cfg_);
    }
}

