/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.common.editorHelp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.ui.ICHelpBook;
import org.eclipse.cdt.ui.ICHelpResourceDescriptor;
import org.eclipse.cdt.ui.IFunctionSummary;
import org.eclipse.cdt.ui.text.ICHelpInvocationContext;
import org.eclipse.ptp.pldt.common.editorHelp.CHelpResourceDescriptorImpl;
import org.eclipse.ptp.pldt.common.editorHelp.FunctionPrototypeSummaryImpl;
import org.eclipse.ptp.pldt.common.editorHelp.FunctionSummaryImpl;
import org.eclipse.ptp.pldt.common.messages.Messages;

public class CHelpBookImpl
implements ICHelpBook {
    private String title = Messages.generic_c_help_book;
    private static final boolean traceOn = false;
    private String pluginId;
    protected Map<String, IFunctionSummary> funcName2FuncInfo = new HashMap<String, IFunctionSummary>();

    private CHelpBookImpl() {
    }

    public CHelpBookImpl(String pluginId) {
        this.pluginId = pluginId;
    }

    public String getTitle() {
        return this.title;
    }

    protected void setTitle(String title) {
        this.title = title;
    }

    public int getCHelpType() {
        return 1;
    }

    public IFunctionSummary getFunctionInfo(ICHelpInvocationContext context, String name) {
        IFunctionSummary fs = this.funcName2FuncInfo.get(name);
        return fs;
    }

    public IFunctionSummary[] getMatchingFunctions(ICHelpInvocationContext context, String prefix) {
        ArrayList<IFunctionSummary> functionSummaryList = new ArrayList<IFunctionSummary>();
        for (String funcName : this.funcName2FuncInfo.keySet()) {
            if (funcName == null || !funcName.toUpperCase().startsWith(prefix.toUpperCase())) continue;
            functionSummaryList.add(this.funcName2FuncInfo.get(funcName));
        }
        IFunctionSummary[] functionSummaryArray = null;
        if (!functionSummaryList.isEmpty()) {
            functionSummaryArray = new IFunctionSummary[functionSummaryList.size()];
            int i = 0;
            Iterator it = functionSummaryList.iterator();
            while (it.hasNext()) {
                functionSummaryArray[i] = (IFunctionSummary)it.next();
                ++i;
            }
        }
        return functionSummaryArray;
    }

    public ICHelpResourceDescriptor[] getHelpResources(ICHelpInvocationContext context, String name) {
        IFunctionSummary functionSummary = this.getFunctionInfo(context, name);
        if (functionSummary == null) {
            return null;
        }
        ICHelpResourceDescriptor[] resourceDescriptor = new ICHelpResourceDescriptor[1];
        CHelpResourceDescriptorImpl hrd = new CHelpResourceDescriptorImpl(this, functionSummary, this.pluginId);
        resourceDescriptor[0] = hrd;
        return resourceDescriptor;
    }

    public void func(String fname, String desc, String retType, String args) {
        this.funcName2FuncInfo.put(fname, new FunctionSummaryImpl(fname, "", desc, new FunctionPrototypeSummaryImpl(fname, retType, args), null));
    }
}

