/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.etfw.jaxb.util;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.bind.JAXBException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ptp.internal.etfw.jaxb.JAXBInitializationUtil;
import org.eclipse.ptp.internal.etfw.jaxb.data.EtfwToolProcessType;
import org.xml.sax.SAXException;

public class JAXBExtensionUtils {
    public static Map<String, IFileStore> fPluginWorkflows = new TreeMap<String, IFileStore>();

    public static String[] getToolNames() {
        JAXBExtensionUtils.loadExtensions();
        Set<String> names = fPluginWorkflows.keySet();
        return names.toArray(new String[0]);
    }

    public static EtfwToolProcessType getTool(String toolName) {
        JAXBExtensionUtils.loadExtensions();
        IFileStore toolFile = fPluginWorkflows.get(toolName);
        EtfwToolProcessType tool = null;
        try {
            String toolXML = JAXBInitializationUtil.getETFWConfigurationXML(toolFile.toURI().toURL());
            tool = JAXBInitializationUtil.initializeEtfwToolProcessType(toolXML);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        return tool;
    }

    private static void loadExtensions() {
        if (fPluginWorkflows.isEmpty()) {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.ptp.etfw.jaxb.workflows");
            IExtension[] extensions = extensionPoint.getExtensions();
            int iext = 0;
            while (iext < extensions.length) {
                IExtension ext = extensions[iext];
                IConfigurationElement[] elements = ext.getConfigurationElements();
                IFileStore ifs = null;
                int i = 0;
                while (i < elements.length) {
                    IConfigurationElement ce = elements[i];
                    try {
                        String plugspace = ext.getNamespaceIdentifier();
                        String toolFile = ce.getAttribute("file");
                        String name = ce.getAttribute("name");
                        URI toolFileUri = new URI(FileLocator.toFileURL((URL)Platform.getBundle((String)plugspace).getEntry(toolFile)).toString().replaceAll(" ", "%20"));
                        ifs = EFS.getLocalFileSystem().getStore(toolFileUri);
                        fPluginWorkflows.put(name, ifs);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    ++i;
                }
                ++iext;
            }
        }
    }

    public static Map<String, IFileStore> getWorkflows() {
        JAXBExtensionUtils.loadExtensions();
        return fPluginWorkflows;
    }
}

