/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.phpunit.model.connection;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.php.internal.debug.core.zend.debugger.RemoteDebugger;
import org.eclipse.php.internal.debug.core.zend.model.PHPDebugTarget;
import org.eclipse.php.phpunit.model.connection.Message;
import org.eclipse.php.phpunit.model.connection.MessageEventType;
import org.eclipse.php.phpunit.model.connection.MessageException;
import org.eclipse.php.phpunit.model.elements.PHPUnitElement;
import org.eclipse.php.phpunit.model.elements.PHPUnitElementManager;
import org.eclipse.php.phpunit.model.elements.PHPUnitTest;
import org.eclipse.php.phpunit.model.elements.PHPUnitTestCase;
import org.eclipse.php.phpunit.model.elements.PHPUnitTestException;
import org.eclipse.php.phpunit.model.elements.PHPUnitTestGroup;
import org.eclipse.php.phpunit.model.elements.PHPUnitTestWarning;
import org.eclipse.php.phpunit.ui.view.PHPUnitView;
import org.eclipse.php.phpunit.ui.view.TestViewer;
import org.eclipse.swt.widgets.Display;

public class PHPUnitMessageParser
implements ISchedulingRule {
    public static final String CALL_DYNAMIC = "->";
    public static final String CALL_STATIC = "::";
    private static final String ELEMENT_TARGET_TESTSUITE = "testsuite";
    private static final String ELEMENT_TARGET_TESTCASE = "testcase";
    private static PHPUnitMessageParser instance;
    private RemoteDebugger remoteDebugger;
    private PHPUnitTestGroup currentGroup;
    private PHPUnitTestCase currentTestCase;
    private boolean inProgress = false;
    private RefreshJob refreshJob = new RefreshJob(this);

    public static PHPUnitMessageParser getInstance() {
        if (instance == null) {
            instance = new PHPUnitMessageParser();
        }
        return instance;
    }

    public void parseMessage(Message message, TestViewer viewer) {
        if (message == null) {
            return;
        }
        try {
            Job.getJobManager().beginRule((ISchedulingRule)this, null);
            if (!this.isInProgress()) {
                this.setInProgress(true);
            }
            String target = message.getTarget();
            MessageEventType event = message.getEvent();
            if (target.equals(ELEMENT_TARGET_TESTSUITE)) {
                if (event == MessageEventType.start) {
                    this.parseGroupStart(viewer, message);
                } else if (event == MessageEventType.end) {
                    this.parseGroupEnd(viewer, message);
                } else {
                    this.currentGroup.setStatus(event);
                    this.currentGroup.addRunCount(1);
                }
            } else if (target.equals(ELEMENT_TARGET_TESTCASE)) {
                if (event == MessageEventType.start) {
                    this.parseTestStart(viewer, message);
                } else {
                    this.parseTestEnd(viewer, message);
                }
            }
            this.refreshJob.schedule(50L);
        }
        finally {
            Job.getJobManager().endRule((ISchedulingRule)this);
        }
    }

    private void parseGroupStart(TestViewer viewer, Message message) {
        if (message.getEvent() != MessageEventType.start) {
            return;
        }
        PHPUnitTestGroup group = new PHPUnitTestGroup(message.getTest(), this.currentGroup, this.remoteDebugger);
        this.mapTest(group);
        if (this.currentGroup.getTotalCount() > 0) {
            this.currentGroup.addChild(group, false);
            viewer.registerViewerUpdate(this.currentGroup);
            viewer.registerTestAdded();
            group.setParent(this.currentGroup);
        }
        this.currentGroup = group;
        this.currentTestCase = null;
        if (this.currentGroup.getTotalCount() > 0 && PHPUnitElementManager.getInstance().getRoot().getTotalCount() == 0) {
            PHPUnitElementManager.getInstance().setRoot(this.currentGroup);
            viewer.registerTestAdded();
        }
    }

    private void parseTestStart(TestViewer viewer, Message message) {
        PHPUnitTestCase testCase;
        this.currentTestCase = testCase = new PHPUnitTestCase(message.getTest(), this.currentGroup, message.getEvent(), this.remoteDebugger);
        this.mapTest(testCase);
        this.currentGroup.addChild(testCase, false);
        viewer.registerTestAdded();
    }

    private void parseTestEnd(TestViewer viewer, Message message) {
        PHPUnitTestCase testCase = this.currentTestCase;
        testCase.setStatus(message.getEvent());
        if (message.getTime() != null) {
            testCase.setTime(message.getTime());
        }
        this.parseProblems(testCase, message);
        this.currentGroup.addChild(testCase, true);
        viewer.registerTestAdded();
        if (testCase.getStatus() > 1) {
            viewer.registerAutoScrollTarget(testCase);
            viewer.registerFailedForAutoScroll(testCase);
        }
    }

    private void parseProblems(PHPUnitTest model, Message message) {
        this.mapException(model, message.getException());
        this.mapWarnings(model, message.getWarnings());
    }

    public void clean() {
        PHPUnitElementManager manager = PHPUnitElementManager.getInstance();
        manager.initialize();
        this.currentGroup = manager.getRoot();
        this.currentTestCase = null;
    }

    public boolean isInProgress() {
        return this.inProgress;
    }

    public void mapException(PHPUnitTest testCase, MessageException exception) {
        if (exception == null) {
            return;
        }
        testCase.setException(new PHPUnitTestException(exception, testCase, this.remoteDebugger));
        this.mapTest(testCase.getException());
    }

    private void mapTest(PHPUnitElement test) {
        PHPUnitElementManager.getInstance().add(test.getTestId(), test);
    }

    private void mapWarnings(PHPUnitTest testCase, Map<Integer, MessageException> warnings) {
        if (warnings == null) {
            return;
        }
        if (testCase.getWarnings() == null) {
            testCase.setWarnings(new ArrayList<PHPUnitElement>(warnings.size()));
        }
        for (Integer key : warnings.keySet()) {
            PHPUnitTestWarning warning = new PHPUnitTestWarning(warnings.get(key), (PHPUnitElement)testCase, this.remoteDebugger);
            this.mapTest(warning);
            testCase.getWarnings().add(key, warning);
        }
    }

    private void parseGroupEnd(TestViewer viewer, Message message) {
        if (this.currentGroup.getChildren() == null) {
            this.parseProblems(this.currentGroup, message);
        }
        this.currentGroup = (PHPUnitTestGroup)this.currentGroup.getParent();
        this.currentTestCase = null;
        viewer.registerViewerUpdate(this.currentGroup);
    }

    public void setInProgress(boolean inProgress) {
        this.inProgress = inProgress;
    }

    public void setDebugTarget(IDebugTarget debugTarget) {
        if (debugTarget instanceof PHPDebugTarget) {
            PHPDebugTarget phpDebugTarget = (PHPDebugTarget)debugTarget;
            this.remoteDebugger = (RemoteDebugger)phpDebugTarget.getRemoteDebugger();
        } else {
            this.remoteDebugger = null;
        }
    }

    public PHPUnitTestCase getCurrentTestCase() {
        return this.currentTestCase;
    }

    public boolean contains(ISchedulingRule rule) {
        return rule == this;
    }

    public boolean isConflicting(ISchedulingRule rule) {
        return rule == this;
    }

    private class RefreshJob
    extends Job {
        public RefreshJob(PHPUnitMessageParser phpUnitMessageParser) {
            super("Refresh PHPUnitView");
            this.setRule(phpUnitMessageParser);
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            Display.getDefault().syncExec(() -> PHPUnitView.getDefault().refresh(PHPUnitElementManager.getInstance().getRoot()));
            return Status.OK_STATUS;
        }
    }
}

