/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.views.vpgproblems;

import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.photran.internal.ui.views.vpgproblems.MarkerDispatchAction;
import org.eclipse.photran.internal.ui.views.vpgproblems.Messages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class ShowFullMessageAction
extends MarkerDispatchAction {
    public ShowFullMessageAction(IWorkbenchSite site) {
        super(site);
        this.setText(Messages.ShowFullMessageAction_EventDetails);
        this.setToolTipText(Messages.ShowFullMessageAction_ShowDetailsTooltip);
    }

    public ShowFullMessageAction(IWorkbenchSite site, String text, String toolTipText) {
        super(site);
        this.setText(text);
        this.setToolTipText(toolTipText);
    }

    public ImageDescriptor getImageDescriptor() {
        Image img = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
        return ImageDescriptor.createFromImage((Image)img);
    }

    @Override
    protected void run(IMarker marker) {
        new DetailsDialog(this.getSite().getShell(), marker).open();
    }

    private static final class DetailsDialog
    extends Dialog {
        private final IMarker marker;

        private DetailsDialog(Shell parentShell, IMarker marker) {
            super(parentShell);
            this.marker = marker;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText(Messages.ShowFullMessageAction_EventDetails);
            shell.setSize(500, 300);
        }

        protected Control createDialogArea(Composite parent) {
            Composite dialogArea = (Composite)super.createDialogArea(parent);
            Text message = new Text(dialogArea, 2634);
            message.setText(MarkerUtilities.getMessage((IMarker)this.marker));
            message.setLayoutData((Object)new GridData(4, 4, true, true));
            dialogArea.layout();
            return dialogArea;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            Button close = this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, true);
            close.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    DetailsDialog.this.close();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    DetailsDialog.this.close();
                }
            });
            close.setFocus();
        }
    }
}

