/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.vpg;

import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.photran.internal.core.util.Pair;
import org.eclipse.photran.internal.core.vpg.IVPGComponentFactory;
import org.eclipse.photran.internal.core.vpg.IVPGNode;
import org.eclipse.photran.internal.core.vpg.Messages;
import org.eclipse.photran.internal.core.vpg.VPGDependency;
import org.eclipse.photran.internal.core.vpg.VPGEdge;

public abstract class VPGDB<A, T, R extends IVPGNode<T>> {
    public static final int ALL_EDGES = Integer.MIN_VALUE;
    protected final IVPGComponentFactory<A, T, R> factory;

    public VPGDB(IVPGComponentFactory<A, T, R> factory) {
        this.factory = factory;
    }

    protected VPGDB(VPGDB<A, T, R> wrappedDB) {
        this.factory = wrappedDB.factory;
    }

    public abstract void flush();

    public abstract void close();

    public abstract void clearDatabase();

    public abstract void enterHypotheticalMode() throws IOException;

    public abstract void leaveHypotheticalMode() throws IOException;

    public abstract boolean isInHypotheticalMode();

    public abstract void updateModificationStamp(String var1);

    public abstract boolean isOutOfDate(String var1);

    public abstract void deleteAllEntriesFor(String var1);

    public abstract void deleteAllEdgesAndAnnotationsFor(String var1);

    public abstract void deleteAllIncomingDependenciesFor(String var1);

    public abstract void deleteAllOutgoingDependenciesFor(String var1);

    public abstract Iterable<String> listAllFilenames();

    public abstract Iterable<String> listAllFilenamesWithDependents();

    public abstract Iterable<String> listAllDependentFilenames();

    public abstract void ensure(VPGDependency<A, T, R> var1);

    public abstract void delete(VPGDependency<A, T, R> var1);

    public abstract Iterable<String> getOutgoingDependenciesFrom(String var1);

    public abstract Iterable<String> getIncomingDependenciesTo(String var1);

    public List<String> sortFilesAccordingToDependencies(List<String> files) {
        int i = 0;
        while (i < files.size()) {
            this.enqueueNewDependents(files.get(i), files);
            ++i;
        }
        class DFS {
            final Integer WHITE = 0;
            final Integer GRAY = 1;
            final Integer BLACK = 2;
            final int numFiles;
            ArrayList<String> result;
            HashMap<String, Integer> color;
            int time;

            DFS(List list) {
                this.numFiles = list.size();
                this.result = new ArrayList(this.numFiles);
                this.color = new HashMap();
                for (String filename : list) {
                    this.color.put(filename, this.WHITE);
                }
                this.time = 0;
                for (String filename : list) {
                    if (this.color.get(filename) != this.WHITE) continue;
                    this.dfsVisit(filename);
                }
            }

            private void dfsVisit(String u) {
                this.color.put(u, this.GRAY);
                ++this.time;
                for (String v : VPGDB.this.getIncomingDependenciesTo(u)) {
                    if (this.color.get(v) != this.WHITE) continue;
                    this.dfsVisit(v);
                }
                this.color.put(u, this.BLACK);
                this.result.add(0, u);
            }
        }
        return (VPGDB)this.new DFS(files).result;
    }

    private void enqueueNewDependents(String filename, List<String> dependents) {
        for (String f : this.findAllFilesDependentUpon(filename)) {
            if (dependents.contains(f)) continue;
            dependents.add(f);
        }
    }

    private Set<String> findAllFilesDependentUpon(String filename) {
        HashSet<String> dependents = new HashSet<String>();
        for (String dependentFilename : this.getIncomingDependenciesTo(filename)) {
            dependents.add(dependentFilename);
        }
        return dependents;
    }

    public abstract void ensure(VPGEdge<A, T, R> var1);

    public abstract void delete(VPGEdge<A, T, R> var1);

    public abstract Iterable<? extends VPGEdge<A, T, R>> getAllEdgesFor(String var1);

    public abstract Iterable<? extends VPGEdge<A, T, R>> getOutgoingEdgesFrom(R var1, int var2);

    public abstract Iterable<? extends VPGEdge<A, T, R>> getIncomingEdgesTo(R var1, int var2);

    public Iterable<R> getOutgoingEdgeTargets(R tokenRef, int edgeType) {
        return new EdgeIterable<A, T, R>(this.getOutgoingEdgesFrom(tokenRef, edgeType), false);
    }

    public Iterable<R> getIncomingEdgeSources(R tokenRef, int edgeType) {
        return new EdgeIterable<A, T, R>(this.getIncomingEdgesTo(tokenRef, edgeType), true);
    }

    public abstract void setAnnotation(R var1, int var2, Serializable var3);

    public void setAnnotation(R token, Enum<?> annotationID, Serializable annotation) {
        this.setAnnotation(token, annotationID.ordinal(), annotation);
    }

    public abstract void deleteAnnotation(R var1, int var2);

    public void deleteAnnotation(R token, Enum<?> annotationID) {
        this.deleteAnnotation(token, annotationID.ordinal());
    }

    public abstract Serializable getAnnotation(R var1, int var2);

    public Serializable getAnnotation(R tokenRef, Enum<?> annotationID) {
        return this.getAnnotation(tokenRef, annotationID.ordinal());
    }

    public abstract Iterable<Pair<R, Integer>> getAllAnnotationsFor(String var1);

    public abstract void printOn(PrintStream var1);

    public abstract void printStatisticsOn(PrintStream var1);

    public abstract void resetStatistics();

    public String describeEdgeType(int edgeType) {
        return Messages.bind((String)Messages.VPGDB_EdgeOfType, (Object)edgeType);
    }

    public String describeAnnotationType(int annotationType) {
        return Messages.bind((String)Messages.VPGDB_AnnotationOfType, (Object)annotationType);
    }

    public String describeToken(String filename, int offset, int length) {
        return Messages.bind((String)Messages.VPGDB_FilenameOffsetLength, (Object[])new Object[]{filename, offset, length});
    }

    private class EdgeIterable<A, T, R extends IVPGNode<T>>
    implements Iterable<R> {
        private Iterable<? extends VPGEdge<A, T, R>> edges;
        private boolean returnSources;

        EdgeIterable(Iterable<? extends VPGEdge<A, T, R>> edges, boolean returnSources) {
            this.edges = edges;
            this.returnSources = returnSources;
        }

        @Override
        public Iterator<R> iterator() {
            final Iterator<? extends VPGEdge<A, T, R>> edgeIterator = this.edges.iterator();
            return new Iterator<R>(){

                @Override
                public boolean hasNext() {
                    return edgeIterator.hasNext();
                }

                @Override
                public R next() {
                    try {
                        VPGEdge edge = (VPGEdge)edgeIterator.next();
                        return EdgeIterable.this.returnSources ? edge.getSource() : edge.getSink();
                    }
                    catch (Exception e) {
                        throw new Error(e);
                    }
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

