/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.cdtinterface.errorparsers;

import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.IErrorParser;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Path;

public class OldGFortranErrorParser
implements IErrorParser {
    String fileName = null;
    int lineNumber = -1;

    public boolean processLine(String line, ErrorParserManager eoParser) {
        return this.processLine(line, eoParser, 2);
    }

    public boolean processLine(String line, ErrorParserManager eoParser, int inheritedSeverity) {
        block24: {
            int firstColon;
            block22: {
                firstColon = line.indexOf(58);
                if (firstColon == 1) {
                    try {
                        String os = System.getProperty("os.name");
                        if (os == null || !os.startsWith("Win")) break block22;
                        try {
                            if (Character.isLetter(line.charAt(0))) {
                                firstColon = line.indexOf(58, 2);
                            }
                        }
                        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
                    }
                    catch (SecurityException os) {
                        // empty catch block
                    }
                }
            }
            if (firstColon != -1) {
                int severity;
                String desc;
                String varName;
                block26: {
                    block25: {
                        block23: {
                            if (!line.startsWith("In file ")) break block23;
                            this.fileName = line.substring(8, firstColon);
                            String lineno = line.substring(firstColon + 1);
                            try {
                                this.lineNumber = Integer.parseInt(lineno);
                                break block24;
                            }
                            catch (NumberFormatException e) {
                                this.lineNumber = -1;
                                this.fileName = null;
                                return false;
                            }
                        }
                        if (!line.startsWith("Error:") && !line.startsWith("Fatal Error:")) break block24;
                        varName = null;
                        desc = line.substring(firstColon + 1).trim();
                        severity = this.extractSeverity("Error", inheritedSeverity);
                        if (this.fileName != null && this.lineNumber != -1) break block25;
                        return false;
                    }
                    if (Path.EMPTY.isValidPath(this.fileName)) break block26;
                    return false;
                }
                try {
                    String tail;
                    int q;
                    int p;
                    IFile file = eoParser.findFileName(this.fileName);
                    if (file != null) {
                        if (eoParser.isConflictingName(this.fileName)) {
                            desc = "[Conflicting names: " + this.fileName + " ] " + desc;
                            file = null;
                        }
                    } else {
                        Path path;
                        file = eoParser.findFilePath(this.fileName);
                        if (file == null && (path = new Path(this.fileName)).segmentCount() > 1) {
                            String name = path.lastSegment();
                            file = eoParser.findFileName(this.fileName);
                            if (file != null && eoParser.isConflictingName(this.fileName)) {
                                desc = "[Conflicting names: " + name + " ] " + desc;
                                file = null;
                            }
                        }
                    }
                    if (file == null) {
                        desc = String.valueOf(desc) + "[" + this.fileName + "]";
                    }
                    if ((p = desc.indexOf("Symbol '")) != -1) {
                        varName = desc.substring(p + 8);
                        varName = (p = varName.indexOf("'")) != -1 ? varName.substring(0, p) : null;
                    }
                    if ((p = desc.indexOf("at (")) != -1 && (q = (tail = desc.substring(p + 4)).indexOf(")")) != -1) {
                        desc = String.valueOf(desc.substring(0, p)) + tail.substring(q + 1);
                    }
                    eoParser.generateMarker((IResource)file, this.lineNumber, desc, severity, varName);
                    this.lineNumber = -1;
                    this.fileName = null;
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    private int extractSeverity(String desc, int defaultSeverity) {
        int severity = defaultSeverity;
        if (desc.startsWith("warning") || desc.startsWith("Warning")) {
            severity = 1;
        }
        return severity;
    }
}

