/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.antlr.runtime;

import java.io.Serializable;
import org.eclipse.persistence.internal.libraries.antlr.runtime.CharStream;
import org.eclipse.persistence.internal.libraries.antlr.runtime.Token;

public class CommonToken
implements Token,
Serializable {
    protected int type;
    protected int line;
    protected int charPositionInLine = -1;
    protected int channel = 0;
    protected transient CharStream input;
    protected String text;
    protected int index = -1;
    protected int start;
    protected int stop;

    public CommonToken(int n) {
        this.type = n;
    }

    public CommonToken(CharStream charStream, int n, int n2, int n3, int n4) {
        this.input = charStream;
        this.type = n;
        this.channel = n2;
        this.start = n3;
        this.stop = n4;
    }

    public CommonToken(int n, String string) {
        this.type = n;
        this.channel = 0;
        this.text = string;
    }

    public CommonToken(Token token) {
        this.text = token.getText();
        this.type = token.getType();
        this.line = token.getLine();
        this.index = token.getTokenIndex();
        this.charPositionInLine = token.getCharPositionInLine();
        this.channel = token.getChannel();
        this.input = token.getInputStream();
        if (token instanceof CommonToken) {
            this.start = ((CommonToken)token).start;
            this.stop = ((CommonToken)token).stop;
        }
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public void setLine(int n) {
        this.line = n;
    }

    @Override
    public String getText() {
        if (this.text != null) {
            return this.text;
        }
        if (this.input == null) {
            return null;
        }
        int n = this.input.size();
        if (this.start < n && this.stop < n) {
            return this.input.substring(this.start, this.stop);
        }
        return "<EOF>";
    }

    @Override
    public void setText(String string) {
        this.text = string;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public int getCharPositionInLine() {
        return this.charPositionInLine;
    }

    @Override
    public void setCharPositionInLine(int n) {
        this.charPositionInLine = n;
    }

    @Override
    public int getChannel() {
        return this.channel;
    }

    @Override
    public void setChannel(int n) {
        this.channel = n;
    }

    @Override
    public void setType(int n) {
        this.type = n;
    }

    public int getStartIndex() {
        return this.start;
    }

    public void setStartIndex(int n) {
        this.start = n;
    }

    public int getStopIndex() {
        return this.stop;
    }

    public void setStopIndex(int n) {
        this.stop = n;
    }

    @Override
    public int getTokenIndex() {
        return this.index;
    }

    @Override
    public void setTokenIndex(int n) {
        this.index = n;
    }

    @Override
    public CharStream getInputStream() {
        return this.input;
    }

    @Override
    public void setInputStream(CharStream charStream) {
        this.input = charStream;
    }

    public String toString() {
        String string;
        String string2 = "";
        if (this.channel > 0) {
            string2 = ",channel=" + this.channel;
        }
        if ((string = this.getText()) != null) {
            string = string.replaceAll("\n", "\\\\n");
            string = string.replaceAll("\r", "\\\\r");
            string = string.replaceAll("\t", "\\\\t");
        } else {
            string = "<no text>";
        }
        return "[@" + this.getTokenIndex() + "," + this.start + ":" + this.stop + "='" + string + "',<" + this.type + ">" + string2 + "," + this.line + ":" + this.getCharPositionInLine() + "]";
    }
}

