/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.shared.target;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.IJobFunction;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.pde.internal.ui.shared.target.Messages;

public class UpdateTargetJob
extends Job {
    public static final String JOB_FAMILY_ID = "UpdateTargetJob";
    private List<IJobFunction> toUpdate;

    public static void update(List<IJobFunction> updateActions, IJobChangeListener listener) {
        Job.getJobManager().cancel((Object)JOB_FAMILY_ID);
        UpdateTargetJob job = new UpdateTargetJob(updateActions);
        job.setUser(true);
        if (listener != null) {
            job.addJobChangeListener(listener);
        }
        job.schedule();
    }

    private UpdateTargetJob(List<IJobFunction> updateActions) {
        super(Messages.UpdateTargetJob_UpdateJobName);
        this.toUpdate = updateActions;
    }

    protected IStatus run(IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.UpdateTargetJob_UpdatingTarget, (int)(this.toUpdate.size() * 100));
        MultiStatus errors = new MultiStatus("org.eclipse.pde.core", 0, Messages.UpdateTargetJob_TargetUpdateFailedStatus, null);
        boolean noChange = true;
        for (IJobFunction action : this.toUpdate) {
            IStatus result = action.run((IProgressMonitor)progress.split(100));
            if (result.isOK() && result.getCode() != 101) {
                noChange = false;
                continue;
            }
            if (result.isOK()) continue;
            noChange = false;
            errors.add(result);
        }
        progress.done();
        if (noChange) {
            return new Status(0, "org.eclipse.pde.core", 101, Messages.UpdateTargetJob_TargetUpdateSuccessStatus, null);
        }
        if (!errors.isOK()) {
            return errors;
        }
        return Status.OK_STATUS;
    }
}

