/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.IModelChangeProvider;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.ModelChangedEvent;
import org.eclipse.pde.core.plugin.ISharedExtensionsModel;
import org.eclipse.pde.internal.core.IModelChangeProviderExtension;
import org.eclipse.pde.internal.core.bundle.BundleFragmentModel;
import org.eclipse.pde.internal.core.bundle.BundlePluginModel;
import org.eclipse.pde.internal.core.bundle.BundlePluginModelBase;
import org.eclipse.pde.internal.core.ibundle.IBundleModel;
import org.eclipse.pde.internal.ui.editor.FormOutlinePage;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.context.InputContext;
import org.eclipse.pde.internal.ui.editor.context.InputContextManager;
import org.eclipse.ui.forms.IFormPart;

public class PluginInputContextManager
extends InputContextManager {
    private BundlePluginModelBase bmodel;

    public PluginInputContextManager(PDEFormEditor editor) {
        super(editor);
    }

    @Override
    public IBaseModel getAggregateModel() {
        if (this.bmodel != null) {
            return this.bmodel;
        }
        return this.findPluginModel();
    }

    public IModel getPluginModel() {
        if (this.bmodel != null) {
            return this.bmodel.getExtensionsModel();
        }
        return this.findPluginModel();
    }

    @Override
    protected void structureChanged(IFile file, boolean added) {
        IProject project;
        if (added && "plugin.xml".equalsIgnoreCase(file.getName()) && ((project = this.getCommonProject()) == null || project.equals((Object)file.getProject()))) {
            this.monitorFile(file);
        }
        super.structureChanged(file, added);
    }

    @Override
    protected void fireContextChange(InputContext context, boolean added) {
        super.fireContextChange(context, added);
        switch (context.getId()) {
            case "bundle-context": {
                if (added) {
                    this.bundleAdded(context);
                    break;
                }
                this.bundleRemoved(context);
                break;
            }
            case "build-context": {
                if (added) {
                    this.buildAdded(context);
                    break;
                }
                this.buildRemoved(context);
                break;
            }
            case "plugin-context": {
                if (added) {
                    this.pluginAdded(context);
                    break;
                }
                this.pluginRemoved(context);
                break;
            }
        }
    }

    private void bundleAdded(InputContext bundleContext) {
        IBundleModel model = (IBundleModel)bundleContext.getModel();
        this.bmodel = model.isFragmentModel() ? new BundleFragmentModel() : new BundlePluginModel();
        this.bmodel.setBundleModel(model);
        this.syncExtensions();
    }

    private void syncExtensions() {
        IModel emodel = this.findPluginModel();
        if (emodel != null && emodel instanceof ISharedExtensionsModel) {
            this.bmodel.setExtensionsModel((ISharedExtensionsModel)emodel);
            this.transferListeners(emodel, (IModel)this.bmodel);
        } else {
            this.bmodel.setExtensionsModel(null);
        }
    }

    private IModel findPluginModel() {
        InputContext pcontext = this.findContext("plugin-context");
        return pcontext != null ? (IModel)pcontext.getModel() : null;
    }

    private void bundleRemoved(InputContext bundleContext) {
        if (this.bmodel != null) {
            BundlePluginModelBase preserved = this.bmodel;
            this.bmodel = null;
            IModel emodel = this.findPluginModel();
            if (emodel != null) {
                this.transferListeners((IModel)preserved, emodel);
            }
        }
    }

    private void transferListeners(IModel source, IModel target) {
        if (source instanceof IModelChangeProviderExtension && target instanceof IModelChangeProviderExtension) {
            IModelChangeProviderExtension smodel = (IModelChangeProviderExtension)source;
            IModelChangeProviderExtension tmodel = (IModelChangeProviderExtension)target;
            smodel.fireModelChanged((IModelChangedEvent)new ModelChangedEvent((IModelChangeProvider)smodel, 99, null, null));
            smodel.transferListenersTo(tmodel, listener -> listener instanceof IFormPart || listener instanceof FormOutlinePage);
        }
    }

    private void pluginAdded(InputContext pluginContext) {
        if (this.bmodel != null) {
            this.syncExtensions();
        }
    }

    private void pluginRemoved(InputContext pluginContext) {
        if (this.bmodel != null) {
            this.syncExtensions();
        }
    }

    private void buildAdded(InputContext buildContext) {
    }

    private void buildRemoved(InputContext buildContext) {
    }
}

