/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.dialogs;

import org.eclipse.core.resources.IContainer;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.NewFolderDialog;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class FolderSelectionDialog
extends ElementTreeSelectionDialog
implements ISelectionChangedListener {
    private Button fNewFolderButton;
    private IContainer fSelectedContainer;

    public FolderSelectionDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider) {
        super(parent, labelProvider, contentProvider);
        this.setComparator((ViewerComparator)new ResourceComparator(1));
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.pde.doc.user.folder_selection_dialog");
    }

    protected Control createDialogArea(Composite parent) {
        Composite result = (Composite)super.createDialogArea(parent);
        this.getTreeViewer().addSelectionChangedListener((ISelectionChangedListener)this);
        this.getTreeViewer().expandToLevel(2);
        this.fNewFolderButton = new Button(result, 8);
        this.fNewFolderButton.setText(PDEUIMessages.BuildEditor_SourceFolderSelectionDialog_button);
        this.fNewFolderButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> this.newFolderButtonPressed()));
        this.fNewFolderButton.setFont(parent.getFont());
        this.fNewFolderButton.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint(this.fNewFolderButton);
        FolderSelectionDialog.applyDialogFont((Control)result);
        return result;
    }

    private void updateNewFolderButtonState() {
        Object first;
        ITreeSelection selection = this.getTreeViewer().getStructuredSelection();
        this.fSelectedContainer = null;
        if (selection.size() == 1 && (first = selection.getFirstElement()) instanceof IContainer) {
            this.fSelectedContainer = (IContainer)first;
        }
        this.fNewFolderButton.setEnabled(this.fSelectedContainer != null);
    }

    protected void newFolderButtonPressed() {
        NewFolderDialog dialog = new NewFolderDialog(this.getShell(), this.fSelectedContainer);
        if (dialog.open() == 0) {
            TreeViewer treeViewer = this.getTreeViewer();
            treeViewer.refresh((Object)this.fSelectedContainer);
            if (dialog.getResult() != null) {
                Object createdFolder = dialog.getResult()[0];
                treeViewer.reveal(createdFolder);
                treeViewer.setSelection((ISelection)new StructuredSelection(createdFolder));
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.updateNewFolderButtonState();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, PDEUIMessages.ManifestEditor_addActionText, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }
}

