/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.base.agreements;

import java.util.Optional;
import org.eclipse.passage.lic.api.agreements.AgreementState;
import org.eclipse.passage.lic.api.diagnostic.Trouble;

final class Assessment
implements AgreementState {
    private final String name;
    private final byte[] content;
    private final boolean accepted;
    private final Optional<Trouble> error;

    Assessment(String name, byte[] content, boolean accepted) {
        this(name, content, accepted, Optional.empty());
    }

    Assessment(String name, byte[] content, Trouble error) {
        this(name, content, false, Optional.of(error));
    }

    Assessment(String name, Trouble error) {
        this(name, new byte[0], false, Optional.of(error));
    }

    private Assessment(String name, byte[] content, boolean accepted, Optional<Trouble> error) {
        this.name = name;
        this.content = content;
        this.accepted = accepted;
        this.error = error;
    }

    public String name() {
        return this.name;
    }

    public byte[] content() {
        return this.content;
    }

    public boolean accepted() {
        return this.accepted;
    }

    public Optional<Trouble> error() {
        return this.error;
    }
}

