/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.validation.api;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.architecture.ArchitectureDescriptionUtils;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureContext;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.services.validation.IValidationFilter;

public abstract class AbstractPapyrusValidationFilter
implements IValidationFilter {
    public boolean isApplicable(EObject element) {
        boolean applicable = false;
        if (element != null && element.eResource() != null && element.eResource().getResourceSet() instanceof ModelSet) {
            Iterator<String> contextIt = this.getExpectedValidationContext().iterator();
            while (!applicable && contextIt.hasNext()) {
                applicable = this.checkContext(element, contextIt.next());
            }
        }
        return applicable;
    }

    private boolean checkContext(EObject element, String expectedContextID) {
        boolean applicable = false;
        ArchitectureDescriptionUtils adUtils = new ArchitectureDescriptionUtils((ModelSet)element.eResource().getResourceSet());
        MergedArchitectureContext architectureContext = adUtils.getArchitectureContext();
        if (architectureContext != null) {
            applicable = architectureContext.getId().equals(expectedContextID);
        }
        return applicable;
    }

    public abstract List<String> getExpectedValidationContext();
}

