/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.drafter.ui.model;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.uml.profile.drafter.ProfileCatalog;
import org.eclipse.papyrus.uml.profile.drafter.exceptions.NotFoundException;
import org.eclipse.papyrus.uml.profile.drafter.ui.model.ExtendedStereotypeModel;
import org.eclipse.papyrus.uml.profile.drafter.ui.model.IModelVisitor;
import org.eclipse.papyrus.uml.profile.drafter.ui.model.MemberKind;
import org.eclipse.papyrus.uml.profile.drafter.ui.model.MetaclassModel;
import org.eclipse.papyrus.uml.profile.drafter.ui.model.MetaclassesModel;
import org.eclipse.papyrus.uml.profile.drafter.ui.model.PropertyModel;
import org.eclipse.papyrus.uml.profile.drafter.ui.model.StateKind;
import org.eclipse.papyrus.uml.profile.drafter.ui.model.StereotypeURL;
import org.eclipse.papyrus.uml.profile.drafter.ui.model.StereotypeURLChangeEvent;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

public class StereoptypeModel
extends StereotypeURL {
    private static final String PROPERTIES = "properties";
    protected Stereotype stereotype;
    protected IObservableList properties = new WritableList();
    protected List<ExtendedStereotypeModel> extendedStereotypes = new ArrayList<ExtendedStereotypeModel>();
    protected List<MetaclassModel> metaclasses = new ArrayList<MetaclassModel>();
    protected MetaclassesModel metaclassesCollection = new MetaclassesModel();
    protected ProfileCatalog profileCatalog;
    private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    private List<String> excludedPropertyNames = Arrays.asList("base_Class");
    final String BASE_PROPERTY_PREFIX = "base_";
    protected Element targetElement;

    public StereoptypeModel() {
    }

    public StereoptypeModel(ProfileCatalog profileCatalog, Element selectedElement) {
        this.profileCatalog = profileCatalog;
        this.targetElement = selectedElement;
    }

    public Stereotype getStereotype() {
        return this.stereotype;
    }

    public void setStereotype(Stereotype stereotype) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public List<PropertyModel> getProperties() {
        return this.properties;
    }

    public List<MetaclassModel> getMetaclasses() {
        return this.metaclasses;
    }

    public List<ExtendedStereotypeModel> getExtendedStereotypes() {
        return this.extendedStereotypes;
    }

    @Override
    protected void qualifiedNameChanged(StereotypeURLChangeEvent event) {
        super.qualifiedNameChanged(event);
        if (this.profileCatalog == null) {
            this.stereotype = null;
            this.resetMetaclasses();
            this.resetExtendedStereotypes();
            this.resetProperties();
            return;
        }
        try {
            this.stereotype = this.profileCatalog.lookupStereotype(this.profileName, this.stereotypeName);
            this.resetMetaclasses();
            this.resetExtendedStereotypes();
            this.resetProperties();
        }
        catch (NotFoundException e) {
            this.stereotype = null;
            this.resetMetaclasses();
            this.resetExtendedStereotypes();
            this.resetProperties();
        }
    }

    protected void resetMetaclasses() {
        this.clearInheritedMetaclasses();
        this.addStereotypeMetaclasses();
    }

    protected void clearInheritedMetaclasses() {
        ArrayList<MetaclassModel> toRetain = new ArrayList<MetaclassModel>();
        for (MetaclassModel model : this.metaclasses) {
            if (model.getStateKind() != StateKind.created) continue;
            toRetain.add(model);
        }
        this.metaclasses.clear();
        this.metaclasses.addAll(toRetain);
    }

    protected void addStereotypeMetaclasses() {
        if (this.stereotype == null) {
            return;
        }
        EList ownedExtendedMetaclasses = this.stereotype.getExtendedMetaclasses();
        for (Class extendedMetaClass : ownedExtendedMetaclasses) {
            this.metaclasses.add(new MetaclassModel(MemberKind.owned, extendedMetaClass));
        }
        for (Class extendedMetaClass : this.stereotype.getAllExtendedMetaclasses()) {
            if (ownedExtendedMetaclasses.contains(extendedMetaClass)) continue;
            this.metaclasses.add(new MetaclassModel(MemberKind.inherited, extendedMetaClass));
        }
    }

    protected void resetExtendedStereotypes() {
        this.clearInheritedExtendedStereotypes();
        this.addProfileExtendedStereotypes();
    }

    protected void clearInheritedExtendedStereotypes() {
        ArrayList<ExtendedStereotypeModel> toRetain = new ArrayList<ExtendedStereotypeModel>();
        for (ExtendedStereotypeModel model : this.extendedStereotypes) {
            if (model.getStateKind() != StateKind.created) continue;
            toRetain.add(model);
        }
        this.extendedStereotypes.clear();
        this.extendedStereotypes.addAll(toRetain);
    }

    protected void addProfileExtendedStereotypes() {
        if (this.stereotype == null) {
            return;
        }
        EList superclasses = this.stereotype.getSuperClasses();
        for (Class superClass : superclasses) {
            this.extendedStereotypes.add(new ExtendedStereotypeModel(MemberKind.owned, superClass));
        }
    }

    protected void resetProperties() {
        this.clearProfileProperties();
        this.addProfileProperties();
    }

    protected void clearProfileProperties() {
        ArrayList<PropertyModel> toRetain = new ArrayList<PropertyModel>();
        for (Object p : this.properties) {
            PropertyModel model = (PropertyModel)p;
            if (model.getStateKind() != StateKind.created) continue;
            toRetain.add(model);
        }
        this.properties.clear();
        this.properties.addAll(toRetain);
    }

    protected void addProfileProperties() {
        if (this.stereotype == null) {
            return;
        }
        EList ownedProperties = this.stereotype.getOwnedAttributes();
        for (Property property : ownedProperties) {
            if (this.isPropertyExcluded(property)) continue;
            this.properties.add((Object)new PropertyModel(MemberKind.owned, property, this.getPropertyValue(property)));
        }
        for (Property property : this.stereotype.getAllAttributes()) {
            if (this.isPropertyExcluded(property) || ownedProperties.contains(property)) continue;
            this.properties.add((Object)new PropertyModel(MemberKind.inherited, property, this.getPropertyValue(property)));
        }
    }

    private boolean isPropertyExcluded(Property property) {
        String base_name;
        String propertyName = property.getName();
        if (propertyName == null) {
            return false;
        }
        if (propertyName.startsWith("base_") && propertyName.equals(base_name = "base_" + property.getType().getName())) {
            return true;
        }
        return this.excludedPropertyNames.contains(property.getName());
    }

    protected Object getPropertyValue(Property property) {
        Object value = null;
        if (property == null || this.stereotype == null) {
            return null;
        }
        value = this.targetElement.getValue(this.stereotype, property.getName());
        return value;
    }

    public PropertyModel createNewPropertyModel() {
        return this.createNewPropertyModel("newProperty");
    }

    public PropertyModel createNewPropertyModel(String propertyName) {
        PropertyModel model = new PropertyModel(MemberKind.owned, propertyName);
        this.properties.add((Object)model);
        return model;
    }

    public MetaclassModel createMetaclassModel(String propertyName) {
        MetaclassModel model = new MetaclassModel(MemberKind.owned, propertyName);
        this.metaclasses.add(model);
        return model;
    }

    public ExtendedStereotypeModel createExtendedStereotypeModel(String propertyName) {
        ExtendedStereotypeModel model = new ExtendedStereotypeModel(MemberKind.owned, propertyName);
        this.extendedStereotypes.add(model);
        return model;
    }

    public void accept(IModelVisitor visitor) {
        visitor.visit(this);
    }

    public void removePropertyModel(int index) {
        if (index < 0) {
            return;
        }
        PropertyModel oldValue = (PropertyModel)this.properties.remove(index);
        PropertyModel newValue = null;
        if (index < this.properties.size()) {
            newValue = (PropertyModel)this.properties.get(index);
        }
        this.fireIndexedPropertyChange(PROPERTIES, index, oldValue, newValue);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(propertyName, listener);
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public MetaclassesModel getMetaclassesCollection() {
        return this.metaclassesCollection;
    }
}

