/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.drafter.ui.handler;

import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.papyrus.uml.profile.drafter.Activator;
import org.eclipse.papyrus.uml.profile.drafter.ProfileApplicator;
import org.eclipse.papyrus.uml.profile.drafter.exceptions.DraftProfileException;
import org.eclipse.papyrus.uml.profile.drafter.ui.handler.AbstractProfileBaseHandler;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Extension;
import org.eclipse.uml2.uml.ExtensionEnd;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;

public class AddProfileHandler
extends AbstractProfileBaseHandler {
    private List<NamedElement> cachedSelectionAsNamedElement;
    private String stereotypeNameInput;
    private String profileNameInput;
    private String taggedValeNameInput;

    @Override
    public String getCommandName() {
        return "Add Profile";
    }

    @Override
    protected boolean preExecute(ExecutionEvent event, IEvaluationContext context) throws ExecutionException {
        String inputName = null;
        InputDialog dialog = new InputDialog(Display.getCurrent().getActiveShell(), "Attach a Stereotype to Selected Element", "Enter the stereotype name.", inputName, null);
        if (dialog.open() == 0) {
            inputName = dialog.getValue();
            if (inputName == null || inputName.length() <= 0) {
                return false;
            }
        } else {
            return false;
        }
        this.taggedValeNameInput = "";
        String[] args = inputName.split(":");
        switch (args.length) {
            case 0: {
                Activator.log.warn("No names found in '" + inputName + "'");
                return false;
            }
            case 1: {
                this.stereotypeNameInput = args[0];
                this.profileNameInput = "testProfile";
                break;
            }
            case 2: {
                this.stereotypeNameInput = args[1].trim();
                this.profileNameInput = args[0].trim();
                break;
            }
            case 3: {
                this.stereotypeNameInput = args[1].trim();
                this.profileNameInput = args[0].trim();
                this.taggedValeNameInput = args[2].trim();
                break;
            }
        }
        return true;
    }

    @Override
    protected void doExecute(ExecutionEvent event, IEvaluationContext context) {
        List<NamedElement> selected = this.getSelectionAsNamedElements(context);
        if (selected.isEmpty()) {
            return;
        }
        ProfileApplicator profileApplicator = new ProfileApplicator(selected.get(0));
        try {
            profileApplicator.applyStereotype2(this.profileNameInput, this.stereotypeNameInput);
        }
        catch (DraftProfileException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void resetCachedValues() {
        super.resetCachedValues();
        this.cachedSelectionAsNamedElement = null;
        this.stereotypeNameInput = null;
        this.profileNameInput = null;
        this.taggedValeNameInput = null;
    }

    protected List<NamedElement> getSelectionAsNamedElements(IEvaluationContext context) {
        if (this.cachedSelectionAsNamedElement == null) {
            this.cachedSelectionAsNamedElement = this.getSelectionsByType(context, NamedElement.class);
        }
        return this.cachedSelectionAsNamedElement;
    }

    protected Extension createExtension(Stereotype source, Type target) {
        Extension newExtension = UMLFactory.eINSTANCE.createExtension();
        ExtensionEnd endSource = UMLFactory.eINSTANCE.createExtensionEnd();
        endSource.setName("extension_" + source.getName());
        endSource.setType((Type)source);
        endSource.setAggregation(AggregationKind.COMPOSITE_LITERAL);
        newExtension.getOwnedEnds().add((Object)endSource);
        Property property = UMLFactory.eINSTANCE.createProperty();
        property.setName("base_" + target.getName());
        property.setType(target);
        property.setAssociation((Association)newExtension);
        property.setAggregation(AggregationKind.NONE_LITERAL);
        newExtension.getMemberEnds().add((Object)property);
        source.getOwnedAttributes().add((Object)property);
        return newExtension;
    }

    @Override
    public boolean isEnabled(IEvaluationContext context, List<Object> selections) {
        return !selections.isEmpty();
    }
}

