/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.m2m.qvto.common.wizard.pages;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.papyrus.infra.widgets.util.FileUtil;
import org.eclipse.papyrus.uml.m2m.qvto.common.wizard.pages.AbstractDialogData;
import org.eclipse.papyrus.uml.m2m.qvto.common.wizard.pages.ImportConfigComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class DialogDataConfigComposite
extends ImportConfigComposite {
    protected AbstractDialogData dialogData;
    protected SelectionListener buttonListener;
    protected Button selectAll;
    protected Button deselectAll;

    public DialogDataConfigComposite(Composite parent, int style, AbstractDialogData dialogData) {
        super(parent, style, dialogData.getConfig());
        this.dialogData = dialogData;
        this.setViewerInput(dialogData.getSelectedFiles());
    }

    @Override
    protected void createSelectionButtons(Composite parent) {
        Composite buttonsComposite = new Composite(parent, 0);
        buttonsComposite.setLayout((Layout)new GridLayout());
        this.buttonListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DialogDataConfigComposite.this.fireButtonSelectionEvent(event);
            }
        };
        this.selectAll = new Button(buttonsComposite, 8);
        this.selectAll.setData((Object)true);
        this.selectAll.setText("Select All");
        this.selectAll.addSelectionListener(this.buttonListener);
        this.selectAll.setLayoutData((Object)new GridData(4, 1, true, false));
        this.deselectAll = new Button(buttonsComposite, 8);
        this.deselectAll.setData((Object)false);
        this.deselectAll.setText("Deselect All");
        this.deselectAll.addSelectionListener(this.buttonListener);
        this.deselectAll.setLayoutData((Object)new GridData(4, 1, true, false));
    }

    protected void fireButtonSelectionEvent(SelectionEvent event) {
        this.listViewer.setAllChecked(((Boolean)((Button)event.widget).getData()).booleanValue());
        this.setTransformationFiles();
        this.setUncheckedFiles();
        if (this.dialogData != null) {
            this.dialogData.setTransformationFiles(this.transformationFiles);
            this.dialogData.setUncheckedFiles(this.uncheckedFiles);
        }
    }

    @Override
    protected void fireSelectionEvent(SelectionChangedEvent event) {
        this.transformationFiles = new LinkedList<Object>(Arrays.asList(this.listViewer.getCheckedElements()));
        this.setUncheckedFiles();
        if (this.dialogData != null) {
            this.dialogData.setTransformationFiles(this.transformationFiles);
            this.dialogData.setUncheckedFiles(this.uncheckedFiles);
        }
    }

    @Override
    public void setViewerInput(Collection<Object> selectedFiles) {
        this.listViewer.setInput(selectedFiles);
        if (this.dialogData != null) {
            if (this.dialogData.getUnSelectionArray() == null) {
                this.listViewer.setAllChecked(true);
            } else {
                List<String> previousUnSelection = Arrays.asList(this.dialogData.getUnSelectionArray());
                for (Object object : selectedFiles) {
                    if (object instanceof IFile) {
                        IFile ifile = (IFile)object;
                        String ifilePath = FileUtil.getPath((IFile)ifile, (boolean)true);
                        if (previousUnSelection.contains(ifilePath)) {
                            this.listViewer.setChecked(object, false);
                            continue;
                        }
                        this.listViewer.setChecked(object, true);
                        continue;
                    }
                    if (!(object instanceof File)) continue;
                    File file = (File)object;
                    String filePath = file.getAbsolutePath();
                    if (previousUnSelection.contains(filePath)) {
                        this.listViewer.setChecked(object, false);
                        continue;
                    }
                    this.listViewer.setChecked(object, true);
                }
            }
            this.setTransformationFiles();
            this.setUncheckedFiles();
            this.dialogData.setTransformationFiles(this.transformationFiles);
            this.dialogData.setUncheckedFiles(this.uncheckedFiles);
        }
    }

    protected void setUncheckedFiles() {
        if (this.dialogData != null) {
            this.uncheckedFiles = new LinkedList();
            for (Object object : this.dialogData.getAllSelectedFiles()) {
                if (this.transformationFiles.contains(object)) continue;
                this.uncheckedFiles.add(object);
            }
            this.dialogData.setUncheckedFiles(this.uncheckedFiles);
        }
    }

    @Override
    public void dispose() {
        if (this.buttonListener != null) {
            this.selectAll.removeSelectionListener(this.buttonListener);
            this.deselectAll.removeSelectionListener(this.buttonListener);
        }
        super.dispose();
    }
}

