/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.policies;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.AlignmentRequest;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.sequence.command.CustomZOrderCommand;
import org.eclipse.papyrus.uml.diagram.sequence.command.SetResizeAndLocationCommand;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.BehaviorExecutionSpecificationEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CCombinedCompartmentEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.DestructionOccurrenceSpecificationEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.OLDLifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.util.LifelineEditPartUtil;
import org.eclipse.papyrus.uml.diagram.sequence.util.OccurrenceSpecificationMoveHelper;
import org.eclipse.papyrus.uml.diagram.sequence.util.SequenceUtil;

@Deprecated
public class OLDLifelineXYLayoutEditPolicy {
    private static final int EXECUTION_INIT_WIDTH = 16;
    private static final int SPACING_HEIGHT = 5;

    @Deprecated
    private OLDLifelineXYLayoutEditPolicy() {
    }

    private static Command resizeParentExecutionSpecification(LifelineEditPart lifelinePart, ShapeNodeEditPart part, Rectangle childBounds, List<ShapeNodeEditPart> list) {
        Rectangle bounds = OLDLifelineXYLayoutEditPolicy.getRelativeBounds(part.getFigure());
        childBounds.x = bounds.x;
        childBounds.width = bounds.width;
        Rectangle rect = bounds.getCopy();
        int spacingY = 5;
        if (childBounds.y - spacingY < rect.y) {
            rect.height += rect.y - childBounds.y + spacingY;
            rect.y = childBounds.y - spacingY;
        } else if (childBounds.bottom() + spacingY > rect.bottom()) {
            rect.height = childBounds.bottom() - rect.y + spacingY;
        } else {
            return null;
        }
        Rectangle newBounds = rect.getCopy();
        CompoundCommand command = new CompoundCommand();
        ICommandProxy c = new ICommandProxy((ICommand)new SetResizeAndLocationCommand(part.getEditingDomain(), "Resize of Parent Bar", (IAdaptable)part, newBounds.getCopy()));
        command.add((Command)c);
        Point moveDelta = new Point(newBounds.x - bounds.x, newBounds.y - bounds.y);
        Dimension sizeDelta = new Dimension(newBounds.width() - bounds.width(), newBounds.height() - bounds.height());
        if (moveDelta.y != 0 || sizeDelta.height() != 0) {
            ChangeBoundsRequest request = new ChangeBoundsRequest();
            request.setEditParts((EditPart)part);
            request.setMoveDelta(moveDelta);
            request.setSizeDelta(sizeDelta);
            command = OccurrenceSpecificationMoveHelper.completeMoveExecutionSpecificationCommand(command, part, newBounds.getCopy(), request);
        }
        list.remove(part);
        ShapeNodeEditPart parent = OLDLifelineXYLayoutEditPolicy.getParent(lifelinePart, part.getFigure().getBounds(), list);
        if (parent == null) {
            return command.unwrap();
        }
        return command.unwrap().chain(OLDLifelineXYLayoutEditPolicy.resizeParentExecutionSpecification(lifelinePart, parent, newBounds.getCopy(), list));
    }

    private static final Rectangle getExecutionSpecificationNewBounds(boolean isMove, LifelineEditPart lifelineEP, Rectangle oldBounds, Rectangle newBounds, List<ShapeNodeEditPart> notToCheckExecutionSpecificationList, boolean useFixedXPos) {
        Rectangle dotLineBounds = lifelineEP.getPrimaryShape().getFigureLifelineDotLineFigure().getBounds();
        if (newBounds.y <= dotLineBounds.y || newBounds.x < dotLineBounds.x || newBounds.x > dotLineBounds.right()) {
            return null;
        }
        List<ShapeNodeEditPart> toCheckExecutionSpecificationList = LifelineEditPartUtil.getChildShapeNodeEditPart(lifelineEP);
        toCheckExecutionSpecificationList.removeAll(notToCheckExecutionSpecificationList);
        if (isMove) {
            ShapeNodeEditPart parent = OLDLifelineXYLayoutEditPolicy.getParent(lifelineEP, newBounds, toCheckExecutionSpecificationList);
            if (useFixedXPos) {
                newBounds.x = oldBounds.x;
            } else if (parent == null) {
                int width = newBounds.width > 0 ? newBounds.width : 16;
                newBounds.x = dotLineBounds.x + dotLineBounds.width / 2 - width / 2;
            } else {
                Rectangle parentBounds = parent.getFigure().getBounds();
                int width = parentBounds.width > 0 ? parentBounds.width : 16;
                newBounds.x = parentBounds.x + width / 2 + 1;
            }
        } else {
            ShapeNodeEditPart oldParent = OLDLifelineXYLayoutEditPolicy.getParent(lifelineEP, oldBounds, toCheckExecutionSpecificationList);
            for (ShapeNodeEditPart esPart : toCheckExecutionSpecificationList) {
                Rectangle esBounds = esPart.getFigure().getBounds();
                int esYBottom = esBounds.y + esBounds.height;
                if (esPart == oldParent || (oldBounds.y + oldBounds.height > esBounds.y || newBounds.y + newBounds.height < esBounds.y) && (oldBounds.y < esYBottom || newBounds.y > esYBottom)) continue;
                return null;
            }
        }
        newBounds.x -= dotLineBounds.x;
        newBounds.y -= dotLineBounds.y;
        return newBounds;
    }

    public static Command getResizeOrMoveChildrenCommand(LifelineEditPart lifelineEP, ChangeBoundsRequest request, boolean isMove, boolean updateEnclosingInteraction, boolean useFixedXPos) {
        List editParts = request.getEditParts();
        if (editParts != null) {
            CompoundCommand compoundCmd = new CompoundCommand();
            compoundCmd.setLabel("Move or resize");
            compoundCmd.setDebugLabel("Debug: Move or resize of a Lifeline's children");
            for (EditPart ep : editParts) {
                if (ep instanceof CCombinedCompartmentEditPart || ep instanceof BehaviorExecutionSpecificationEditPart) {
                    ShapeNodeEditPart executionSpecificationEP = (ShapeNodeEditPart)ep;
                    Dimension newSizeDelta = OLDLifelineXYLayoutEditPolicy.adaptSizeDeltaToMaxHeight(executionSpecificationEP.getFigure(), request.getSizeDelta());
                    Rectangle oldBounds = executionSpecificationEP.getFigure().getBounds().getCopy();
                    Rectangle newBounds = oldBounds.getCopy();
                    if (request instanceof AlignmentRequest) {
                        AlignmentRequest alignmentRequest = (AlignmentRequest)request;
                        switch (alignmentRequest.getAlignment()) {
                            case 1: 
                            case 2: 
                            case 4: 
                            case 64: {
                                return UnexecutableCommand.INSTANCE;
                            }
                        }
                        newBounds = alignmentRequest.getAlignmentRectangle().getCopy();
                        executionSpecificationEP.getFigure().translateToRelative((Translatable)newBounds);
                        newBounds.x = oldBounds.x;
                    } else {
                        Dimension unZoomedMoveDelta = new Dimension(request.getMoveDelta().x, request.getMoveDelta().y);
                        executionSpecificationEP.getFigure().translateToRelative((Translatable)unZoomedMoveDelta);
                        newBounds.x += unZoomedMoveDelta.width;
                        newBounds.y += unZoomedMoveDelta.height;
                        Dimension unZoomedSizeDelta = newSizeDelta.getCopy();
                        executionSpecificationEP.getFigure().translateToRelative((Translatable)unZoomedSizeDelta);
                        newBounds.height += unZoomedSizeDelta.height;
                    }
                    BasicEList notToCheckExecutionSpecificationList = new BasicEList();
                    notToCheckExecutionSpecificationList.addAll(OLDLifelineXYLayoutEditPolicy.getAffixedExecutionSpecificationEditParts(executionSpecificationEP));
                    notToCheckExecutionSpecificationList.add(executionSpecificationEP);
                    List<ShapeNodeEditPart> executionSpecificationList = LifelineEditPartUtil.getChildShapeNodeEditPart(lifelineEP);
                    executionSpecificationList.remove(executionSpecificationEP);
                    ShapeNodeEditPart parentBar = OLDLifelineXYLayoutEditPolicy.getParent(lifelineEP, newBounds, executionSpecificationList);
                    newBounds = OLDLifelineXYLayoutEditPolicy.getExecutionSpecificationNewBounds(isMove, lifelineEP, oldBounds, newBounds, (List<ShapeNodeEditPart>)notToCheckExecutionSpecificationList, useFixedXPos);
                    if (newBounds == null) {
                        return UnexecutableCommand.INSTANCE;
                    }
                    if (parentBar != null) {
                        compoundCmd.add(OLDLifelineXYLayoutEditPolicy.resizeParentExecutionSpecification(lifelineEP, parentBar, newBounds.getCopy(), executionSpecificationList));
                    }
                    SetResizeAndLocationCommand setBoundsCmd = new SetResizeAndLocationCommand(executionSpecificationEP.getEditingDomain(), "Resize of a ExecutionSpecification", (IAdaptable)executionSpecificationEP, newBounds);
                    compoundCmd.add((Command)new ICommandProxy((ICommand)setBoundsCmd));
                    Rectangle realMoveDelta = OLDLifelineXYLayoutEditPolicy.getRealMoveDelta(OLDLifelineXYLayoutEditPolicy.getRelativeBounds(executionSpecificationEP.getFigure()), newBounds);
                    if (isMove) {
                        compoundCmd.add((Command)OLDLifelineXYLayoutEditPolicy.createMovingAffixedExecutionSpecificationCommand(executionSpecificationEP, realMoveDelta, newBounds.getCopy()));
                        compoundCmd.add(OLDLifelineXYLayoutEditPolicy.createZOrderCommand(lifelineEP, executionSpecificationEP, newBounds.getCopy(), (List<ShapeNodeEditPart>)notToCheckExecutionSpecificationList));
                    }
                    compoundCmd = OccurrenceSpecificationMoveHelper.completeMoveExecutionSpecificationCommand(compoundCmd, executionSpecificationEP, newBounds, request);
                    IFigure parentFigure = executionSpecificationEP.getFigure().getParent();
                    parentFigure.translateToAbsolute((Translatable)newBounds);
                    newBounds.translate(parentFigure.getBounds().getLocation());
                    if (updateEnclosingInteraction) {
                        compoundCmd.add(SequenceUtil.createUpdateEnclosingInteractionCommand(executionSpecificationEP, request.getMoveDelta(), newSizeDelta));
                    }
                    compoundCmd.add((Command)new ICommandProxy((ICommand)new OLDLifelineEditPart.PreserveAnchorsPositionCommandEx(executionSpecificationEP, new Dimension(realMoveDelta.width, realMoveDelta.height), 0, executionSpecificationEP.getFigure(), request.getResizeDirection())));
                }
                if (!(ep instanceof DestructionOccurrenceSpecificationEditPart)) continue;
                Rectangle rectLifeline = lifelineEP.getFigure().getBounds();
                compoundCmd = OLDLifelineXYLayoutEditPolicy.getSetLifelineHeightCommand(compoundCmd, lifelineEP, rectLifeline.height + request.getMoveDelta().y);
            }
            if (!compoundCmd.isEmpty()) {
                return compoundCmd;
            }
        }
        return null;
    }

    @Deprecated
    private static CompoundCommand getSetLifelineHeightCommand(CompoundCommand compoundCmd, LifelineEditPart lifelineEP, int newHeight) {
        throw new IllegalStateException();
    }

    private static final Command createZOrderCommand(LifelineEditPart lifelineEP, ShapeNodeEditPart executionSpecificationEP, Rectangle newBounds, List<ShapeNodeEditPart> notToCheckExecutionSpecificationList) {
        List<ShapeNodeEditPart> toCheckExecutionSpecificationList = LifelineEditPartUtil.getChildShapeNodeEditPart(lifelineEP);
        toCheckExecutionSpecificationList.removeAll(notToCheckExecutionSpecificationList);
        CompoundCommand cmd = new CompoundCommand();
        block0: for (ShapeNodeEditPart externalExecutionSpecificationEP : toCheckExecutionSpecificationList) {
            View containerView;
            Rectangle externalExecutionSpecificationBounds = OLDLifelineXYLayoutEditPolicy.getRelativeBounds(externalExecutionSpecificationEP.getFigure());
            if (!externalExecutionSpecificationBounds.touches(newBounds) || (containerView = ViewUtil.getContainerView((View)executionSpecificationEP.getPrimaryView())) == null) continue;
            int i = 0;
            int parentIndex = -1;
            int childIndex = -1;
            for (Object child : containerView.getChildren()) {
                if (child == externalExecutionSpecificationEP.getPrimaryView()) {
                    parentIndex = i;
                } else if (child == executionSpecificationEP.getPrimaryView()) {
                    childIndex = i;
                }
                if (parentIndex != -1 && childIndex != -1) {
                    if (childIndex <= parentIndex) continue block0;
                    cmd.add((Command)new ICommandProxy((ICommand)new CustomZOrderCommand(executionSpecificationEP.getEditingDomain(), executionSpecificationEP.getPrimaryView(), parentIndex)));
                    cmd.add((Command)new ICommandProxy((ICommand)new CustomZOrderCommand(externalExecutionSpecificationEP.getEditingDomain(), externalExecutionSpecificationEP.getPrimaryView(), childIndex)));
                }
                ++i;
            }
        }
        if (!cmd.isEmpty()) {
            return cmd;
        }
        return null;
    }

    public static final ShapeNodeEditPart getParent(LifelineEditPart lifelinePart, Rectangle childBounds, List<ShapeNodeEditPart> toCheckExecutionSpecificationList) {
        ShapeNodeEditPart parent = null;
        Rectangle externalBounds = childBounds.getCopy();
        for (ShapeNodeEditPart externalExecutionSpecificationEP : toCheckExecutionSpecificationList) {
            Rectangle externalExecutionSpecificationBounds = externalExecutionSpecificationEP.getFigure().getBounds();
            externalBounds.x = externalExecutionSpecificationBounds.x;
            externalBounds.width = externalExecutionSpecificationBounds.width;
            if (!externalExecutionSpecificationBounds.touches(externalBounds) || externalExecutionSpecificationBounds.x > childBounds.x || parent != null && externalExecutionSpecificationBounds.x <= parent.getFigure().getBounds().x) continue;
            parent = externalExecutionSpecificationEP;
        }
        return parent;
    }

    public static final Dimension adaptSizeDeltaToMaxHeight(IFigure figure, Dimension sizeDelta) {
        Dimension newSizeDelta = new Dimension(sizeDelta);
        int figureHeight = figure.getBounds().height;
        int maximunFigureHeight = figure.getMaximumSize().height;
        int minimunFigureHeight = figure.getMinimumSize().height;
        int height = figureHeight + newSizeDelta.height;
        if (height > maximunFigureHeight) {
            newSizeDelta.height = maximunFigureHeight - figureHeight;
        } else if (height < minimunFigureHeight) {
            newSizeDelta.height = minimunFigureHeight - figureHeight;
        }
        return newSizeDelta;
    }

    public static final List<ShapeNodeEditPart> getAffixedExecutionSpecificationEditParts(ShapeNodeEditPart executionSpecificationEP) {
        ArrayList<ShapeNodeEditPart> notToCheckExecutionSpecificationList = new ArrayList<ShapeNodeEditPart>();
        return OLDLifelineXYLayoutEditPolicy.getAffixedExecutionSpecificationEditParts(executionSpecificationEP, notToCheckExecutionSpecificationList);
    }

    private static final List<ShapeNodeEditPart> getAffixedExecutionSpecificationEditParts(ShapeNodeEditPart executionSpecificationEP, List<ShapeNodeEditPart> notToCheckExecutionSpecificationList) {
        ArrayList<ShapeNodeEditPart> newNotToCheckExecutionSpecificationList = new ArrayList<ShapeNodeEditPart>(notToCheckExecutionSpecificationList);
        newNotToCheckExecutionSpecificationList.add(executionSpecificationEP);
        LifelineEditPart lifelineEP = (LifelineEditPart)executionSpecificationEP.getParent();
        List<ShapeNodeEditPart> executionSpecificationList = LifelineEditPartUtil.getChildShapeNodeEditPart(lifelineEP);
        executionSpecificationList.removeAll(newNotToCheckExecutionSpecificationList);
        ArrayList<ShapeNodeEditPart> affixedExecutionSpecificationList = new ArrayList<ShapeNodeEditPart>();
        for (ShapeNodeEditPart childExecutionSpecificationEP : executionSpecificationList) {
            if (!OLDLifelineXYLayoutEditPolicy.isAffixedToRight(executionSpecificationEP.getFigure().getBounds(), childExecutionSpecificationEP.getFigure().getBounds())) continue;
            affixedExecutionSpecificationList.add(childExecutionSpecificationEP);
            affixedExecutionSpecificationList.addAll(OLDLifelineXYLayoutEditPolicy.getAffixedExecutionSpecificationEditParts(childExecutionSpecificationEP, newNotToCheckExecutionSpecificationList));
        }
        return affixedExecutionSpecificationList;
    }

    public static final boolean isAffixedToRight(Rectangle leftFigure, Rectangle rightFigure) {
        return leftFigure.contains(rightFigure.getLocation()) && leftFigure.x < rightFigure.x;
    }

    private static final CompoundCommand createMovingAffixedExecutionSpecificationCommand(ShapeNodeEditPart executionSpecificationEP, Rectangle moveDelta, Rectangle newBounds) {
        if (moveDelta.y != 0 || moveDelta.height != 0) {
            CompoundCommand compoundCmd = new CompoundCommand();
            for (ShapeNodeEditPart childExecutionSpecificationEP : OLDLifelineXYLayoutEditPolicy.getAffixedExecutionSpecificationEditParts(executionSpecificationEP)) {
                Rectangle childBounds = OLDLifelineXYLayoutEditPolicy.getRelativeBounds(childExecutionSpecificationEP.getFigure());
                childBounds.y += moveDelta.y;
                childBounds.x += moveDelta.x;
                SetResizeAndLocationCommand childSetBoundsCmd = new SetResizeAndLocationCommand(executionSpecificationEP.getEditingDomain(), "Movement of affixed ExecutionSpecification", (IAdaptable)childExecutionSpecificationEP, childBounds);
                compoundCmd.add((Command)new ICommandProxy((ICommand)childSetBoundsCmd));
                IFigure parentFigure = childExecutionSpecificationEP.getFigure().getParent();
                parentFigure.translateToAbsolute((Translatable)newBounds);
                newBounds.translate(parentFigure.getBounds().getLocation());
                compoundCmd.add(SequenceUtil.createUpdateEnclosingInteractionCommand(childExecutionSpecificationEP, moveDelta.getLocation(), moveDelta.getSize()));
                ChangeBoundsRequest request = new ChangeBoundsRequest();
                request.setMoveDelta(new Point(0, moveDelta.y));
                OccurrenceSpecificationMoveHelper.completeMoveExecutionSpecificationCommand(compoundCmd, childExecutionSpecificationEP, childBounds.getCopy(), request);
                if (OLDLifelineXYLayoutEditPolicy.getAffixedExecutionSpecificationEditParts(childExecutionSpecificationEP).isEmpty()) continue;
                compoundCmd.add((Command)OLDLifelineXYLayoutEditPolicy.createMovingAffixedExecutionSpecificationCommand(childExecutionSpecificationEP, moveDelta, childBounds));
            }
            if (!compoundCmd.isEmpty()) {
                return compoundCmd;
            }
        }
        return null;
    }

    public static final Rectangle getRealMoveDelta(Rectangle oldRelativeBounds, Rectangle newRelativeBounds) {
        Rectangle realMoveDelta = new Rectangle();
        realMoveDelta.x = newRelativeBounds.x - oldRelativeBounds.x;
        realMoveDelta.y = newRelativeBounds.y - oldRelativeBounds.y;
        realMoveDelta.height = newRelativeBounds.height - oldRelativeBounds.height;
        realMoveDelta.width = newRelativeBounds.width - oldRelativeBounds.width;
        return realMoveDelta;
    }

    public static final Rectangle getRelativeBounds(IFigure figure) {
        Rectangle relBounds = figure.getBounds().getCopy();
        Rectangle parentRectangle = figure.getParent().getBounds();
        relBounds.x -= parentRectangle.x;
        relBounds.y -= parentRectangle.y;
        return relBounds;
    }
}

