/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.internal.uml.diagram.sequence.elk;

import java.util.Objects;
import org.eclipse.papyrus.internal.uml.diagram.sequence.elk.KVector;

public class ElkRectangle {
    public double x;
    public double y;
    public double width;
    public double height;

    public ElkRectangle() {
        this(0.0, 0.0, 0.0, 0.0);
    }

    public ElkRectangle(double x, double y, double w, double h) {
        this.x = x;
        this.y = y;
        this.width = w;
        this.height = h;
    }

    public ElkRectangle(ElkRectangle rect) {
        this.x = rect.x;
        this.y = rect.y;
        this.width = rect.width;
        this.height = rect.height;
    }

    public void setRect(double nx, double ny, double nw, double nh) {
        this.x = nx;
        this.y = ny;
        this.width = nw;
        this.height = nh;
    }

    public KVector getPosition() {
        return new KVector(this.x, this.y);
    }

    public KVector getTopLeft() {
        return this.getPosition();
    }

    public KVector getTopRight() {
        return new KVector(this.x + this.width, this.y);
    }

    public KVector getBottomLeft() {
        return new KVector(this.x, this.y + this.height);
    }

    public KVector getBottomRight() {
        return new KVector(this.x + this.width, this.y + this.height);
    }

    public KVector getCenter() {
        return new KVector(this.x + this.width / 2.0, this.y + this.height / 2.0);
    }

    public void union(ElkRectangle other) {
        double t;
        double x1 = Math.min(this.x, other.x);
        double y1 = Math.min(this.y, other.y);
        double x2 = Math.max(this.x + this.width, other.x + other.width);
        double y2 = Math.max(this.y + this.height, other.y + other.height);
        if (x2 < x1) {
            t = x1;
            x1 = x2;
            x2 = t;
        }
        if (y2 < y1) {
            t = y1;
            y1 = y2;
            y2 = t;
        }
        this.setRect(x1, y1, x2 - x1, y2 - y1);
    }

    public void move(KVector offset) {
        this.x += offset.x;
        this.y += offset.y;
    }

    public String toString() {
        return "Rect[x=" + this.x + ",y=" + this.y + ",w=" + this.width + ",h=" + this.height + "]";
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ElkRectangle)) {
            return false;
        }
        ElkRectangle other = (ElkRectangle)obj;
        return Objects.equals(this.x, other.x) && Objects.equals(this.y, other.y) && Objects.equals(this.width, other.width) && Objects.equals(this.height, other.height);
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y, this.width, this.height);
    }
}

