/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.decoratormodel.internal.ui.wizards;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.uml.decoratormodel.internal.ui.Activator;
import org.eclipse.papyrus.uml.decoratormodel.internal.ui.wizards.DecoratorModelSelectionPage;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.uml2.uml.Package;

abstract class AbstractManageProfileApplicationsWizard
extends Wizard
implements IWorkbenchWizard {
    private final boolean autoPrompt;
    private Package package_;
    private Set<URI> availableResources;
    private IFile[] selectedResources;
    private DecoratorModelSelectionPage mainPage;

    public AbstractManageProfileApplicationsWizard(boolean autoPrompt) {
        this.autoPrompt = autoPrompt;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        EObject eObject = EMFHelper.getEObject((Object)selection.getFirstElement());
        if (eObject instanceof Package) {
            this.init((Package)eObject, Collections.emptyList());
        }
    }

    public void init(Package package_, Iterable<URI> initialSelections) {
        this.package_ = package_;
        this.availableResources = this.getAvailableProfileApplicationResources(package_);
        EventBus bus = new EventBus("wizard");
        bus.register((Object)this);
        this.createPages(package_, bus);
        this.initPages(package_, (Iterable<URI>)ImmutableList.copyOf(initialSelections));
    }

    protected void createPages(Package package_, EventBus bus) {
        this.mainPage = this.createSelectionPage(bus);
        this.mainPage.setIsAutomaticPrompt(this.isAutoPrompt());
        this.configureSelectionPage(this.mainPage);
    }

    protected void initPages(Package package_, Iterable<URI> initialSelections) {
        this.mainPage.setInput(package_, this.availableResources);
        this.mainPage.select(initialSelections);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.mainPage);
    }

    public IWizardPage getStartingPage() {
        IWizardPage result = super.getStartingPage();
        if (this.mainPage != null && this.mainPage.canFlipToNextPage()) {
            result = this.mainPage.getNextPage();
        }
        return result;
    }

    protected DecoratorModelSelectionPage createSelectionPage(EventBus bus) {
        return new DecoratorModelSelectionPage(bus);
    }

    protected void configureSelectionPage(DecoratorModelSelectionPage page) {
    }

    protected boolean isAutoPrompt() {
        return this.autoPrompt;
    }

    abstract Set<URI> getAvailableProfileApplicationResources(Package var1);

    protected IDialogSettings getSection(String sectionName, boolean createIfNecessary) {
        IDialogSettings result;
        IDialogSettings settings = Activator.getDefault().getDialogSettings().getSection(((Object)((Object)this)).getClass().getSimpleName());
        if (settings == null && createIfNecessary) {
            settings = Activator.getDefault().getDialogSettings().addNewSection(((Object)((Object)this)).getClass().getSimpleName());
        }
        IDialogSettings iDialogSettings = result = settings == null ? null : settings.getSection(sectionName);
        if (result == null && createIfNecessary) {
            result = settings.addNewSection(sectionName);
        }
        return result;
    }

    protected IDialogSettings getSection(IDialogSettings settings, String sectionName, boolean createIfNecessary) {
        IDialogSettings result = settings.getSection(sectionName);
        if (result == null && createIfNecessary) {
            result = settings.addNewSection(sectionName);
        }
        return result;
    }

    @Subscribe
    public void resourcesSelected(IFile[] resources) {
        this.selectedResources = resources;
    }

    public boolean isComplete() {
        return this.mainPage != null && this.mainPage.isPageComplete();
    }

    protected final Package getPackage() {
        return this.package_;
    }

    public boolean performFinish() {
        ResourceSet resourceSet = this.getPackage().eResource().getResourceSet();
        HashSet resourceURIs = Sets.newHashSet();
        IFile[] iFileArray = this.selectedResources;
        int n = this.selectedResources.length;
        int n2 = 0;
        while (n2 < n) {
            IFile next = iFileArray[n2];
            resourceURIs.add(URI.createPlatformResourceURI((String)next.getFullPath().toString(), (boolean)true));
            ++n2;
        }
        return this.performFinish(resourceSet, resourceURIs);
    }

    protected abstract boolean performFinish(ResourceSet var1, Set<URI> var2);
}

