/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.emf.providers.strategy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.ui.emf.utils.ProviderHelper;
import org.eclipse.papyrus.infra.widgets.providers.IAdaptableContentProvider;
import org.eclipse.papyrus.infra.widgets.strategy.ProviderBasedBrowseStrategy;
import org.eclipse.swt.widgets.TreeItem;

public class ContainmentBrowseStrategy
extends ProviderBasedBrowseStrategy<TreeViewer> {
    protected IAdaptableContentProvider adaptableProvider;

    public ContainmentBrowseStrategy(ITreeContentProvider provider) {
        if (!(provider instanceof IAdaptableContentProvider)) {
            throw new IllegalArgumentException("The provider must be an IAdaptableContentProvider");
        }
        this.setProvider(provider);
        this.adaptableProvider = (IAdaptableContentProvider)this.provider;
    }

    protected boolean browseElement(Object containerElement) {
        Object semanticElement = this.adaptableProvider.getAdaptedValue(containerElement);
        if (semanticElement instanceof EReference) {
            return ((EReference)semanticElement).isContainment() && !((EReference)semanticElement).isDerived();
        }
        return true;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (viewer instanceof TreeViewer) {
            this.viewer = (TreeViewer)viewer;
        }
        super.inputChanged(viewer, oldInput, newInput);
    }

    public void revealSemanticElement(List<?> elementList) {
        List<EObject> eobjects = elementList.stream().filter(EObject.class::isInstance).map(EObject.class::cast).collect(Collectors.toList());
        ProviderHelper.selectReveal(eobjects, (StructuredViewer)this.viewer);
    }

    public void expandItems(List<Object> treeElementList, TreeItem[] list) {
        ((TreeViewer)this.viewer).getTree().setRedraw(false);
        if (treeElementList.size() > 0) {
            int i = 0;
            while (i < list.length) {
                if (list[i].getData() != null && list[i].getData().equals(treeElementList.get(0))) {
                    if (treeElementList.size() > 1) {
                        Object[] toexpand = new Object[]{treeElementList.get(0)};
                        ((TreeViewer)this.viewer).setExpandedElements(toexpand);
                    }
                    ArrayList<Object> tmpList = new ArrayList<Object>();
                    tmpList.addAll(treeElementList);
                    tmpList.remove(tmpList.get(0));
                    this.expandItems(tmpList, list[i].getItems());
                }
                ++i;
            }
        }
        ((TreeViewer)this.viewer).getTree().setRedraw(true);
    }

    @Deprecated
    public void selectReveal(ISelection selection) {
        if (this.viewer != null) {
            ((TreeViewer)this.viewer).setSelection(selection, true);
        }
    }

    @Deprecated
    protected List<Object> searchDirectContainmentPath(EObject eobject, List<Object> wrappedElements) {
        ArrayList<Object> path = new ArrayList<Object>();
        List emfPath = EMFHelper.getContainmentPath((EObject)eobject);
        for (Object wrappedElement : wrappedElements) {
            List<Object> wrappedChildren;
            List<Object> childPath;
            EObject element = EMFHelper.getEObject((Object)wrappedElement);
            if (eobject.equals(element)) {
                return Collections.singletonList(wrappedElement);
            }
            if (!this.browseElementForDirectContainment(emfPath, element) || (childPath = this.searchDirectContainmentPath(eobject, wrappedChildren = Arrays.asList(this.provider.getChildren(wrappedElement)))).isEmpty()) continue;
            path.add(wrappedElement);
            path.addAll(childPath);
            break;
        }
        return path;
    }

    @Deprecated
    protected boolean browseElementForDirectContainment(List<EObject> emfPath, EObject element) {
        EReference reference;
        if (emfPath.contains(element)) {
            return true;
        }
        return element instanceof EReference && (reference = (EReference)element).isContainment() && !reference.isDerived();
    }

    @Deprecated
    protected List<Object> searchPath(EObject eobject, List<Object> objects) {
        List<Object> path = this.searchDirectContainmentPath(eobject, objects);
        if (!path.isEmpty()) {
            return path;
        }
        path = new ArrayList<Object>();
        for (Object o : objects) {
            if (!(o instanceof Diagram) && eobject.equals(EMFHelper.getEObject((Object)o))) {
                path.add(o);
                return path;
            }
            int i = 0;
            while (i < this.provider.getChildren(o).length) {
                Object last;
                EObject lastEObject;
                Object treeItem = this.provider.getChildren(o)[i];
                List<Object> tmppath = new ArrayList();
                EObject element = EMFHelper.getEObject((Object)treeItem);
                if (this.browseElement(element)) {
                    ArrayList<Object> childs = new ArrayList<Object>();
                    childs.add(treeItem);
                    tmppath = this.searchPath(eobject, childs);
                }
                if (tmppath.size() > 0 && eobject.equals(lastEObject = EMFHelper.getEObject(last = tmppath.get(tmppath.size() - 1)))) {
                    path.add(o);
                    path.addAll(tmppath);
                    return path;
                }
                ++i;
            }
        }
        return new ArrayList<Object>();
    }
}

