/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.resourceloading;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.URI;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.sasheditor.SashModelUtils;
import org.eclipse.papyrus.infra.services.controlmode.history.HistoryModel;
import org.eclipse.papyrus.infra.services.controlmode.history.utils.HistoryUtils;
import org.eclipse.papyrus.infra.services.controlmode.mm.history.ControledResource;
import org.eclipse.papyrus.infra.services.resourceloading.ControledResourceAdapter;

public class HistoryRoutingUtils {
    public static Set<String> getAllControledURIs(ModelSet set, HistoryModel model, URI initialURI, boolean loadCorrespondantDI) {
        HashSet<String> result = new HashSet<String>();
        String path = HistoryUtils.getURIFullPath((URI)SashModelUtils.getInitialURI((ModelSet)set)).toString();
        if (model != null && initialURI != null) {
            ControledResourceAdapter adapter = HistoryRoutingUtils.getControledResourceAdapter(set);
            set.getResource(URI.createURI((String)path.concat(initialURI.trimFragment().trimFileExtension().appendFileExtension("di").toString())), loadCorrespondantDI);
            List<ControledResource> elements = adapter.getControledResource(initialURI.toString());
            for (ControledResource c : elements) {
                for (ControledResource child : c.getChildren()) {
                    URI childURI = URI.createURI((String)child.getResourceURL());
                    result.add(childURI.toString());
                    result.addAll(HistoryRoutingUtils.getAllControledURIs(set, model, childURI, loadCorrespondantDI));
                }
            }
        }
        return result;
    }

    public static ControledResourceAdapter getControledResourceAdapter(ModelSet set) {
        ControledResourceAdapter adapter = null;
        for (Adapter a : set.eAdapters()) {
            if (!(a instanceof ControledResourceAdapter)) continue;
            adapter = (ControledResourceAdapter)a;
        }
        if (adapter == null) {
            adapter = new ControledResourceAdapter(set);
        }
        return adapter;
    }
}

