/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.glazedlists.copy;

import java.util.List;
import org.eclipse.papyrus.infra.nattable.glazedlists.copy.MouseOnlySortingStrategy;
import org.eclipse.papyrus.infra.nattable.glazedlists.copy.SortingState;
import org.eclipse.papyrus.infra.nattable.glazedlists.copy.SortingStrategy;

public class MouseOnlySortingStrategyWithUndo
implements SortingStrategy {
    private final SortingStrategy decorated = new MouseOnlySortingStrategy(true);

    @Override
    public void columnClicked(SortingState sortingState, int column, int clicks, boolean shift, boolean control) {
        boolean isLastComparatorForPrimarySortColumn;
        SortingState.SortingColumn clickedColumn = sortingState.getColumns().get(column);
        if (clickedColumn.getComparators().isEmpty()) {
            return;
        }
        List<SortingState.SortingColumn> recentlyClickedColumns = sortingState.getRecentlyClickedColumns();
        boolean wasPrimarySortColumnClicked = !recentlyClickedColumns.isEmpty() && clickedColumn == recentlyClickedColumns.get(0);
        boolean isPrimarySortColumnReversed = clickedColumn.isReverse();
        boolean bl = isLastComparatorForPrimarySortColumn = clickedColumn.getComparatorIndex() == clickedColumn.getComparators().size() - 1;
        if (wasPrimarySortColumnClicked && isPrimarySortColumnReversed && isLastComparatorForPrimarySortColumn) {
            sortingState.clearComparators();
            sortingState.fireSortingChanged();
            return;
        }
        this.decorated.columnClicked(sortingState, column, clicks, shift, control);
    }
}

