/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.doc.internal.filters;

import java.io.OutputStream;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.help.webapp.IFilter;
import org.eclipse.papyrus.infra.doc.internal.filters.HTMLHeadAndBodyInjectionStream;

public class PapyrusContentFilter
implements IFilter {
    private static final String[] STYLESHEET_PATH = new String[]{"help", "topic", "org.eclipse.papyrus.infra.doc", "resource", "stylesheet.css"};
    private static final String[] BANNER_PATH = new String[]{"help", "topic", "org.eclipse.papyrus.infra.doc", "resource", "PapyrusLeftBanner.gif"};

    public OutputStream filter(HttpServletRequest req, OutputStream out) {
        if (req.getRequestURI().startsWith("/help/topic/org.eclipse.papyrus.")) {
            String[] reqPath = req.getRequestURI().substring(1).split("/");
            String cssPath = String.join((CharSequence)"/", PapyrusContentFilter.relativize(STYLESHEET_PATH, reqPath));
            String headContent = String.format("<link href=\"%s\" rel=\"stylesheet\" type=\"text/css\"/>", cssPath);
            String bannerPath = String.join((CharSequence)"/", PapyrusContentFilter.relativize(BANNER_PATH, reqPath));
            String bodyContent = String.format("<img src=\"%s\" alt=\"Papyrus Banner\" class=\"papyrus-banner\"/>", bannerPath);
            return new HTMLHeadAndBodyInjectionStream(out, req.getCharacterEncoding(), headContent, bodyContent);
        }
        return out;
    }

    static String[] relativize(String[] path, String[] base) {
        int i = 0;
        int j = 0;
        while (i < path.length && j < base.length) {
            if (!path[i].equals(base[j])) break;
            ++i;
            ++j;
        }
        ArrayList<String> result = new ArrayList<String>(base.length);
        ++j;
        while (j < base.length) {
            result.add("..");
            ++j;
        }
        while (i < path.length) {
            result.add(path[i]);
            ++i;
        }
        return (String[])result.toArray(String[]::new);
    }
}

