/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.architecture.representation.provider;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.papyrus.infra.architecture.representation.OwningRule;
import org.eclipse.papyrus.infra.architecture.representation.RepresentationFactory;
import org.eclipse.papyrus.infra.architecture.representation.RepresentationPackage;
import org.eclipse.papyrus.infra.architecture.representation.provider.EClassPropertyDescriptor;
import org.eclipse.papyrus.infra.architecture.representation.provider.RuleItemProvider;
import org.eclipse.papyrus.infra.architecture.representation.provider.StereotypePropertyDescriptor;

public class OwningRuleItemProvider
extends RuleItemProvider {
    public OwningRuleItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addElementPropertyDescriptor(object);
            this.addStereotypesPropertyDescriptor(object);
            this.addMultiplicityPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addElementPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(new EClassPropertyDescriptor((IItemPropertyDescriptor)this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_OwningRule_element_feature"), this.getString("_UI_OwningRule_element_description"), (EStructuralFeature)RepresentationPackage.Literals.OWNING_RULE__ELEMENT, true, false, true, null, null, null)));
    }

    protected void addStereotypesPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(new StereotypePropertyDescriptor((IItemPropertyDescriptor)this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_OwningRule_stereotypes_feature"), this.getString("_UI_OwningRule_stereotypes_description"), (EStructuralFeature)RepresentationPackage.Literals.OWNING_RULE__STEREOTYPES, true, false, true, null, null, null)));
    }

    protected void addMultiplicityPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_OwningRule_multiplicity_feature"), this.getString("_UI_OwningRule_multiplicity_description"), (EStructuralFeature)RepresentationPackage.Literals.OWNING_RULE__MULTIPLICITY, true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE, null, null));
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(RepresentationPackage.Literals.OWNING_RULE__NEW_MODEL_PATH);
            this.childrenFeatures.add(RepresentationPackage.Literals.OWNING_RULE__SELECT_DIAGRAM_ROOT);
        }
        return this.childrenFeatures;
    }

    protected EStructuralFeature getChildFeature(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/OwningRule"));
    }

    @Override
    public String getText(Object object) {
        OwningRule rule = (OwningRule)object;
        StringBuilder builder = new StringBuilder("Owner: ");
        if (!rule.getStereotypes().isEmpty()) {
            builder.append("<<");
            int i = 0;
            while (i != rule.getStereotypes().size()) {
                if (i != 0) {
                    builder.append(",");
                }
                builder.append(((EClass)rule.getStereotypes().get(i)).getName());
                ++i;
            }
            builder.append(">> ");
        }
        builder.append(rule.getElement() != null ? rule.getElement().getName() : "#");
        builder.append("[");
        builder.append(rule.getMultiplicity() == -1 ? "*" : Integer.valueOf(rule.getMultiplicity()));
        builder.append("] => ");
        builder.append(rule.isPermit() ? "allow" : "deny");
        return builder.toString();
    }

    @Override
    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(OwningRule.class)) {
            case 3: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
            case 4: 
            case 5: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        newChildDescriptors.add(this.createChildParameter(RepresentationPackage.Literals.OWNING_RULE__NEW_MODEL_PATH, RepresentationFactory.eINSTANCE.createModelAutoCreate()));
        newChildDescriptors.add(this.createChildParameter(RepresentationPackage.Literals.OWNING_RULE__SELECT_DIAGRAM_ROOT, RepresentationFactory.eINSTANCE.createRootAutoSelect()));
    }
}

