/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.custom.ui;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.internal.treeproxy.EAttributeTreeElement;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.internal.treeproxy.EObjectTreeElement;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.internal.treeproxy.EReferenceTreeElement;

public final class CustomizedContentProviderUtils {
    private CustomizedContentProviderUtils() {
    }

    public static ISelection resolveSelection(ISelection selection) {
        ArrayList<Object> resolvedElements;
        Assert.isNotNull((Object)selection);
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection strSelection = (IStructuredSelection)selection;
            resolvedElements = new ArrayList<Object>();
            for (Object element : strSelection) {
                resolvedElements.add(CustomizedContentProviderUtils.resolve(element));
            }
        } else {
            throw new IllegalArgumentException("Unhandled selection type: " + selection.getClass().getName());
        }
        StructuredSelection result = new StructuredSelection(resolvedElements);
        return result;
    }

    public static Object resolve(Object element) {
        Object resolved = element;
        if (element instanceof EObjectTreeElement) {
            resolved = ((EObjectTreeElement)element).getEObject();
        } else if (element instanceof EAttributeTreeElement) {
            resolved = ((EAttributeTreeElement)element).getEAttribute();
        } else if (element instanceof EReferenceTreeElement) {
            resolved = ((EReferenceTreeElement)element).getEReference();
        }
        return resolved;
    }
}

