/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.promise;

import java.util.Objects;
import org.osgi.annotation.versioning.ProviderType;
import org.osgi.util.promise.DeferredPromiseImpl;
import org.osgi.util.promise.Promise;
import org.osgi.util.promise.PromiseFactory;

@ProviderType
public class Deferred<T> {
    private final DeferredPromiseImpl<T> promise;

    public Deferred() {
        this(PromiseFactory.defaultFactory);
    }

    Deferred(PromiseFactory factory) {
        this.promise = new DeferredPromiseImpl(factory);
    }

    public Promise<T> getPromise() {
        return this.promise;
    }

    public void resolve(T value) {
        this.promise.resolve(value, null);
    }

    public void fail(Throwable failure) {
        this.promise.resolve(null, Objects.requireNonNull(failure));
    }

    public Promise<Void> resolveWith(Promise<? extends T> with) {
        return this.promise.resolveWith(with);
    }

    public String toString() {
        return this.promise.toString();
    }
}

