/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.version.ui.preferences;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxViewerCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.oomph.internal.ui.AbstractPreferencePage;
import org.eclipse.oomph.internal.version.Activator;
import org.eclipse.oomph.version.VersionUtil;
import org.eclipse.oomph.version.ui.preferences.Messages;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class VersionBuilderPreferencePage
extends AbstractPreferencePage {
    private final Map<String, Activator.ReleaseCheckMode> releaseCheckModes = new LinkedHashMap<String, Activator.ReleaseCheckMode>();
    private final Map<String, Activator.LaxLowerBoundCheckMode> lowerBoundCheckModes = new LinkedHashMap<String, Activator.LaxLowerBoundCheckMode>();

    public VersionBuilderPreferencePage() {
        try {
            this.noDefaultButton();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        ArrayList releasePaths = new ArrayList(Activator.getReleasePaths());
        Collections.sort(releasePaths);
        for (String releasePath : releasePaths) {
            Activator.ReleaseCheckMode releaseCheckMode = Activator.getReleaseCheckMode((String)releasePath);
            if (releaseCheckMode == null) {
                releaseCheckMode = Activator.ReleaseCheckMode.FULL;
            }
            this.releaseCheckModes.put(releasePath, releaseCheckMode);
            Activator.LaxLowerBoundCheckMode laxLowerBoundCheckMode = Activator.getLaxLowerBoundCheckMode((String)releasePath);
            if (laxLowerBoundCheckMode == null) {
                laxLowerBoundCheckMode = Activator.LaxLowerBoundCheckMode.SAME_RELEASE;
            }
            this.lowerBoundCheckModes.put(releasePath, laxLowerBoundCheckMode);
        }
    }

    protected Control doCreateContents(Composite parent) {
        final Set<String> releasePaths = this.releaseCheckModes.keySet();
        final TableViewer viewer = new TableViewer(parent, 68112);
        final Table table = viewer.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableViewerColumn releaseViewerColumn = new TableViewerColumn(viewer, 0);
        final TableColumn releaseColumn = releaseViewerColumn.getColumn();
        releaseColumn.setText(Messages.VersionBuilderPreferencePage_column_release);
        releaseColumn.setResizable(false);
        releaseColumn.setMoveable(false);
        TableViewerColumn checkModeViewerColumn = new TableViewerColumn(viewer, 0);
        final TableColumn checkModeColumn = checkModeViewerColumn.getColumn();
        checkModeColumn.setText(Messages.VersionBuilderPreferencePage_column_checkMode);
        checkModeColumn.setResizable(false);
        checkModeColumn.setMoveable(false);
        checkModeColumn.pack();
        checkModeColumn.setWidth(checkModeColumn.getWidth() + 10);
        checkModeColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean uniform = true;
                Activator.ReleaseCheckMode minimumReleaseCheckMode = null;
                for (String releasePath : releasePaths) {
                    Activator.ReleaseCheckMode releaseCheckMode = (Activator.ReleaseCheckMode)VersionBuilderPreferencePage.this.releaseCheckModes.get(releasePath);
                    if (minimumReleaseCheckMode == null) {
                        minimumReleaseCheckMode = releaseCheckMode;
                        continue;
                    }
                    if (minimumReleaseCheckMode.equals((Object)releaseCheckMode)) continue;
                    uniform = false;
                    if (releaseCheckMode.compareTo((Enum)minimumReleaseCheckMode) >= 0) continue;
                    minimumReleaseCheckMode = releaseCheckMode;
                }
                if (uniform) {
                    Activator.ReleaseCheckMode[] values = Activator.ReleaseCheckMode.values();
                    minimumReleaseCheckMode = values[(minimumReleaseCheckMode.ordinal() + 1) % values.length];
                }
                for (String releasePath : releasePaths) {
                    VersionBuilderPreferencePage.this.releaseCheckModes.put(releasePath, minimumReleaseCheckMode);
                }
                viewer.refresh();
            }
        });
        TableViewerColumn lowerBoundCheckModeViewerColumn = new TableViewerColumn(viewer, 0);
        final TableColumn lowerBoundCheckModeColumn = lowerBoundCheckModeViewerColumn.getColumn();
        lowerBoundCheckModeColumn.setText(Messages.VersionBuilderPreferencePage_column_lowerBoundCheckMode);
        lowerBoundCheckModeColumn.setResizable(false);
        lowerBoundCheckModeColumn.setMoveable(false);
        lowerBoundCheckModeColumn.pack();
        lowerBoundCheckModeColumn.setWidth(lowerBoundCheckModeColumn.getWidth() + 10);
        lowerBoundCheckModeColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean uniform = true;
                Activator.LaxLowerBoundCheckMode minimumLowerBoundCheckMode = null;
                for (String releasePath : releasePaths) {
                    Activator.LaxLowerBoundCheckMode lowerBoundCheckMode = (Activator.LaxLowerBoundCheckMode)VersionBuilderPreferencePage.this.lowerBoundCheckModes.get(releasePath);
                    if (minimumLowerBoundCheckMode == null) {
                        minimumLowerBoundCheckMode = lowerBoundCheckMode;
                        continue;
                    }
                    if (minimumLowerBoundCheckMode.equals((Object)lowerBoundCheckMode)) continue;
                    uniform = false;
                    if (lowerBoundCheckMode.compareTo((Enum)minimumLowerBoundCheckMode) >= 0) continue;
                    minimumLowerBoundCheckMode = lowerBoundCheckMode;
                }
                if (uniform) {
                    Activator.LaxLowerBoundCheckMode[] values = Activator.LaxLowerBoundCheckMode.values();
                    minimumLowerBoundCheckMode = values[(minimumLowerBoundCheckMode.ordinal() + 1) % values.length];
                }
                for (String releasePath : releasePaths) {
                    VersionBuilderPreferencePage.this.lowerBoundCheckModes.put(releasePath, minimumLowerBoundCheckMode);
                }
                viewer.refresh();
            }
        });
        final ControlAdapter columnResizer = new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Point size = table.getSize();
                ScrollBar bar = table.getVerticalBar();
                if (bar != null && bar.isVisible()) {
                    size.x -= bar.getSize().x;
                }
                releaseColumn.setWidth(size.x - checkModeColumn.getWidth() - lowerBoundCheckModeColumn.getWidth());
            }
        };
        table.addControlListener((ControlListener)columnResizer);
        table.getDisplay().asyncExec(new Runnable(){

            public void run() {
                columnResizer.controlResized(null);
            }
        });
        viewer.setColumnProperties(new String[]{"releasePath", "checkMode", "lowerBoundCheckMode"});
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new ReleaseCheckModeLabelProvider());
        viewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return "checkMode".equals(property) || "lowerBoundCheckMode".equals(property);
            }

            public Object getValue(Object element, String property) {
                if (property.equals("checkMode")) {
                    return VersionBuilderPreferencePage.this.releaseCheckModes.get(element);
                }
                return VersionBuilderPreferencePage.this.lowerBoundCheckModes.get(element);
            }

            public void modify(Object element, String property, Object value) {
                if (element instanceof TableItem) {
                    element = ((TableItem)element).getData();
                }
                String releasePath = (String)element;
                if (property.equals("checkMode")) {
                    VersionBuilderPreferencePage.this.releaseCheckModes.put(releasePath, (Activator.ReleaseCheckMode)value);
                } else {
                    VersionBuilderPreferencePage.this.lowerBoundCheckModes.put(releasePath, (Activator.LaxLowerBoundCheckMode)value);
                }
                viewer.update(element, new String[]{property});
            }
        });
        ComboBoxViewerCellEditor checkModeCellEditor = new ComboBoxViewerCellEditor((Composite)table, 8);
        checkModeCellEditor.setContentProvider(new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return Activator.ReleaseCheckMode.values();
            }
        });
        checkModeCellEditor.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        checkModeCellEditor.setInput(releasePaths);
        ComboBoxViewerCellEditor lowerBoundCheckModeCellEditor = new ComboBoxViewerCellEditor((Composite)table, 8);
        lowerBoundCheckModeCellEditor.setContentProvider(new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return Activator.LaxLowerBoundCheckMode.values();
            }
        });
        lowerBoundCheckModeCellEditor.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        lowerBoundCheckModeCellEditor.setInput(releasePaths);
        CellEditor[] cellEditorArray = new CellEditor[3];
        cellEditorArray[1] = checkModeCellEditor;
        cellEditorArray[2] = lowerBoundCheckModeCellEditor;
        viewer.setCellEditors(cellEditorArray);
        viewer.setInput(releasePaths);
        releaseColumn.pack();
        table.setSize(releaseColumn.getWidth() + checkModeColumn.getWidth() + lowerBoundCheckModeColumn.getWidth(), 100);
        return table;
    }

    public boolean performOk() {
        this.performApply();
        return true;
    }

    protected void performApply() {
        String releasePath;
        HashSet<String> changedReleases = new HashSet<String>();
        for (Map.Entry<String, Activator.ReleaseCheckMode> entry : this.releaseCheckModes.entrySet()) {
            Activator.ReleaseCheckMode oldReleaseCheckMode;
            releasePath = entry.getKey();
            Activator.ReleaseCheckMode releaseCheckMode = entry.getValue();
            if (releaseCheckMode == (oldReleaseCheckMode = Activator.getReleaseCheckMode((String)releasePath))) continue;
            Activator.setReleaseCheckMode((String)releasePath, (Activator.ReleaseCheckMode)releaseCheckMode);
            if (oldReleaseCheckMode == null && releaseCheckMode == Activator.ReleaseCheckMode.FULL) continue;
            changedReleases.add(releasePath);
        }
        for (Map.Entry<String, Activator.ReleaseCheckMode> entry : this.lowerBoundCheckModes.entrySet()) {
            Activator.LaxLowerBoundCheckMode oldLaxLowerBoundCheckMode;
            releasePath = entry.getKey();
            Activator.LaxLowerBoundCheckMode laxLowerBoundCheckMode = (Activator.LaxLowerBoundCheckMode)entry.getValue();
            if (laxLowerBoundCheckMode == (oldLaxLowerBoundCheckMode = Activator.getLaxLowerBoundCheckMode((String)releasePath))) continue;
            Activator.setLaxLowerBoundCheckMode((String)releasePath, (Activator.LaxLowerBoundCheckMode)laxLowerBoundCheckMode);
            if (oldLaxLowerBoundCheckMode == null && laxLowerBoundCheckMode == Activator.LaxLowerBoundCheckMode.SAME_RELEASE) continue;
            changedReleases.add(releasePath);
        }
        if (!changedReleases.isEmpty()) {
            VersionUtil.rebuildReleaseProjects(changedReleases);
        }
    }

    private final class ReleaseCheckModeLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private ReleaseCheckModeLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String releasePath = element.toString();
            if (columnIndex == 0) {
                return releasePath;
            }
            if (columnIndex == 1) {
                Activator.ReleaseCheckMode releaseCheckMode = (Activator.ReleaseCheckMode)VersionBuilderPreferencePage.this.releaseCheckModes.get(releasePath);
                return releaseCheckMode.toString();
            }
            Activator.LaxLowerBoundCheckMode laxLowerBoundCheckMode = (Activator.LaxLowerBoundCheckMode)VersionBuilderPreferencePage.this.lowerBoundCheckModes.get(releasePath);
            return laxLowerBoundCheckMode.toString();
        }
    }
}

