/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui.recorder;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.oomph.preferences.PreferenceNode;
import org.eclipse.oomph.preferences.PreferencesFactory;
import org.eclipse.oomph.preferences.Property;
import org.eclipse.oomph.preferences.util.PreferencesUtil;
import org.eclipse.oomph.setup.impl.PreferenceTaskImpl;
import org.eclipse.oomph.setup.ui.recorder.RecorderTransaction;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecorderPoliciesComposite
extends Composite
implements ISelectionProvider {
    private final boolean clean;
    private final CheckboxTableViewer viewer;
    private ViewerFilter filter;
    private RecorderTransaction transaction;
    private String[] sortedKeys;

    public RecorderPoliciesComposite(Composite parent, int style, boolean clean) {
        super(parent, 0);
        this.clean = clean;
        this.setLayout((Layout)new FillLayout(256));
        TableColumnLayout tableLayout = new TableColumnLayout();
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayout((Layout)tableLayout);
        this.viewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)style);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                String path = (String)event.getElement();
                boolean policy = event.getChecked();
                RecorderPoliciesComposite.this.transaction.setPolicy(path, policy);
            }
        });
        this.viewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                return false;
            }

            public boolean isChecked(Object element) {
                return Boolean.TRUE.equals(RecorderPoliciesComposite.this.transaction.getPolicy(element.toString()));
            }
        });
        TableColumn column = new TableColumn(this.viewer.getTable(), 16384);
        tableLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(100));
    }

    public final void setRecorderTransaction(RecorderTransaction transaction) {
        this.transaction = transaction;
        Map<String, Boolean> policies = transaction.getPolicies(this.clean);
        PreferenceNode rootPreferenceNode = PreferencesUtil.getRootPreferenceNode(Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList("bundle_defaults", "default", "instance"))), (boolean)false);
        this.collectPolicies(policies, rootPreferenceNode);
        this.sortedKeys = policies.keySet().toArray(new String[policies.size()]);
        Arrays.sort(this.sortedKeys);
        this.viewer.setInput((Object)this.sortedKeys);
        if (this.sortedKeys.length != 0) {
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)this.sortedKeys[0]));
        }
    }

    private void collectPolicies(Map<String, Boolean> policies, PreferenceNode node) {
        for (PreferenceNode child : node.getChildren()) {
            this.collectPolicies(policies, child);
        }
        for (Property property : node.getProperties()) {
            URI relativePath = property.getRelativePath();
            URI instance = URI.createURI((String)"//instance");
            URI resolve = instance.appendSegments(relativePath.segments());
            if (!PreferenceTaskImpl.PreferenceHandler.getHandler((URI)resolve).isIgnored()) continue;
            policies.put(PreferencesFactory.eINSTANCE.convertURI(resolve), false);
        }
    }

    public final void setFilter(ViewerFilter filter) {
        ViewerFilter[] viewerFilterArray;
        this.filter = filter;
        if (filter == null) {
            viewerFilterArray = new ViewerFilter[]{};
        } else {
            ViewerFilter[] viewerFilterArray2 = new ViewerFilter[1];
            viewerFilterArray = viewerFilterArray2;
            viewerFilterArray2[0] = filter;
        }
        this.viewer.setFilters(viewerFilterArray);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.viewer.getTable().setEnabled(enabled);
    }

    public CheckboxTableViewer getViewer() {
        return this.viewer;
    }

    public String getFirstVisiblePolicy() {
        if (this.sortedKeys != null && this.sortedKeys.length != 0) {
            if (this.filter == null) {
                return this.sortedKeys[0];
            }
            String[] stringArray = this.sortedKeys;
            int n = this.sortedKeys.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                if (this.filter.select((Viewer)this.viewer, (Object)this.sortedKeys, (Object)key)) {
                    return key;
                }
                ++n2;
            }
        }
        return null;
    }

    public void selectFirstPolicy() {
        this.viewer.getTable().setSelection(0);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.viewer.addSelectionChangedListener(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.viewer.removeSelectionChangedListener(listener);
    }

    public IStructuredSelection getSelection() {
        return (IStructuredSelection)this.viewer.getSelection();
    }

    public void setSelection(ISelection selection) {
        this.viewer.setSelection(selection);
    }

    public void setSelection(ISelection selection, boolean reveal) {
        this.viewer.setSelection(selection, reveal);
    }

    public void addCheckStateListener(ICheckStateListener listener) {
        this.viewer.addCheckStateListener(listener);
    }

    public void removeCheckStateListener(ICheckStateListener listener) {
        this.viewer.removeCheckStateListener(listener);
    }

    public boolean getChecked(Object element) {
        return this.viewer.getChecked(element);
    }

    public Object[] getCheckedElements() {
        return this.viewer.getCheckedElements();
    }

    public void setAllChecked(boolean state) {
        this.viewer.setAllChecked(state);
    }

    public boolean setChecked(Object element, boolean state) {
        return this.viewer.setChecked(element, state);
    }

    public void setCheckedElements(Object[] elements) {
        this.viewer.setCheckedElements(elements);
    }

    public boolean setFocus() {
        return this.viewer.getTable().setFocus();
    }

    protected void checkSubclass() {
    }
}

