/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.maven.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.MavenUpdateRequest;
import org.eclipse.oomph.setup.SetupTaskContext;
import org.eclipse.oomph.setup.impl.SetupTaskImpl;
import org.eclipse.oomph.setup.maven.MavenPackage;
import org.eclipse.oomph.setup.maven.MavenUpdateTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenUpdateTaskImpl
extends SetupTaskImpl
implements MavenUpdateTask {
    protected EList<String> projectNamePatterns;
    protected static final boolean OFFLINE_EDEFAULT = false;
    protected boolean offline = false;
    protected static final boolean UPDATE_SNAPSHOTS_EDEFAULT = false;
    protected boolean updateSnapshots = false;

    protected MavenUpdateTaskImpl() {
    }

    protected EClass eStaticClass() {
        return MavenPackage.Literals.MAVEN_UPDATE_TASK;
    }

    @Override
    public EList<String> getProjectNamePatterns() {
        if (this.projectNamePatterns == null) {
            this.projectNamePatterns = new EDataTypeUniqueEList(String.class, (InternalEObject)this, 10);
        }
        return this.projectNamePatterns;
    }

    @Override
    public boolean isOffline() {
        return this.offline;
    }

    @Override
    public void setOffline(boolean newOffline) {
        boolean oldOffline = this.offline;
        this.offline = newOffline;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 11, oldOffline, this.offline));
        }
    }

    @Override
    public boolean isUpdateSnapshots() {
        return this.updateSnapshots;
    }

    @Override
    public void setUpdateSnapshots(boolean newUpdateSnapshots) {
        boolean oldUpdateSnapshots = this.updateSnapshots;
        this.updateSnapshots = newUpdateSnapshots;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 12, oldUpdateSnapshots, this.updateSnapshots));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 10: {
                return this.getProjectNamePatterns();
            }
            case 11: {
                return this.isOffline();
            }
            case 12: {
                return this.isUpdateSnapshots();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 10: {
                this.getProjectNamePatterns().clear();
                this.getProjectNamePatterns().addAll((Collection)newValue);
                return;
            }
            case 11: {
                this.setOffline((Boolean)newValue);
                return;
            }
            case 12: {
                this.setUpdateSnapshots((Boolean)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 10: {
                this.getProjectNamePatterns().clear();
                return;
            }
            case 11: {
                this.setOffline(false);
                return;
            }
            case 12: {
                this.setUpdateSnapshots(false);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 10: {
                return this.projectNamePatterns != null && !this.projectNamePatterns.isEmpty();
            }
            case 11: {
                return this.offline;
            }
            case 12: {
                return this.updateSnapshots;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (projectNamePatterns: ");
        result.append(this.projectNamePatterns);
        result.append(", offline: ");
        result.append(this.offline);
        result.append(", updateSnapshots: ");
        result.append(this.updateSnapshots);
        result.append(')');
        return result.toString();
    }

    public boolean isNeeded(SetupTaskContext context) throws Exception {
        return true;
    }

    private boolean matchesNameFilter(String projectName) {
        if (this.projectNamePatterns.isEmpty()) {
            return true;
        }
        for (String pattern : this.getProjectNamePatterns()) {
            if (!Pattern.matches(pattern, projectName)) continue;
            return true;
        }
        return false;
    }

    private List<IProject> getFilteredProjects() throws CoreException {
        ArrayList<IProject> projects = new ArrayList<IProject>();
        IMavenProjectFacade[] iMavenProjectFacadeArray = MavenPlugin.getMavenProjectRegistry().getProjects();
        int n = iMavenProjectFacadeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMavenProjectFacade projectFacade = iMavenProjectFacadeArray[n2];
            if (this.matchesNameFilter(projectFacade.getProject().getName())) {
                projects.add(projectFacade.getProject());
            }
            ++n2;
        }
        return projects;
    }

    public void perform(SetupTaskContext context) throws Exception {
        List<IProject> projects = this.getFilteredProjects();
        MavenUpdateRequest updateRequest = new MavenUpdateRequest(projects.toArray(new IProject[0]), this.isOffline(), this.isUpdateSnapshots());
        MavenPlugin.getMavenProjectRegistry().refresh(updateRequest);
    }
}

