/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.resource;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.ContentHandler;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.URIHandlerImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.internal.manager.TemplateParameterSubstitutionVisitor;
import org.eclipse.ocl.pivot.internal.prettyprint.EssentialOCLPrettyPrintVisitor;
import org.eclipse.ocl.pivot.internal.prettyprint.PrettyPrintVisitor;
import org.eclipse.ocl.pivot.internal.prettyprint.PrettyPrinter;
import org.eclipse.ocl.pivot.internal.resource.ASResourceFactory;
import org.eclipse.ocl.pivot.internal.resource.ASResourceFactoryRegistry;
import org.eclipse.ocl.pivot.internal.resource.ASResourceImpl;
import org.eclipse.ocl.pivot.internal.resource.ASSaver;
import org.eclipse.ocl.pivot.internal.resource.LUSSIDs;
import org.eclipse.ocl.pivot.internal.resource.PivotLUSSIDs;
import org.eclipse.ocl.pivot.internal.utilities.AS2Moniker;
import org.eclipse.ocl.pivot.internal.utilities.AS2XMIid;
import org.eclipse.ocl.pivot.internal.utilities.EcoreTechnology;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.PivotEnvironmentFactory;
import org.eclipse.ocl.pivot.internal.utilities.Technology;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.resource.CSResource;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.utilities.AS2MonikerVisitor;
import org.eclipse.ocl.pivot.utilities.AS2XMIidVisitor;
import org.eclipse.ocl.pivot.utilities.ASSaverLocateVisitor;
import org.eclipse.ocl.pivot.utilities.ASSaverNormalizeVisitor;
import org.eclipse.ocl.pivot.utilities.ASSaverResolveVisitor;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.ocl.pivot.utilities.Pivotable;
import org.eclipse.ocl.pivot.utilities.ToStringVisitor;
import org.eclipse.ocl.pivot.utilities.XMIUtil;

public abstract class AbstractASResourceFactory
extends ResourceFactoryImpl
implements ASResourceFactory.ASResourceFactoryExtension2 {
    protected final @NonNull String contentType;
    private final @Nullable String asFileExtension;

    protected static <T extends AbstractASResourceFactory> @NonNull T getInstances(@NonNull String contentType, @NonNull String asFileExtension, @Nullable String csFileExtension, @NonNull Class<? extends T> resourceFactoryClass) {
        AbstractASResourceFactory contentTypeInstance;
        AbstractASResourceFactory newInstance = null;
        Map contentTypeToFactoryMap = Resource.Factory.Registry.INSTANCE.getContentTypeToFactoryMap();
        Object object1 = contentTypeToFactoryMap.get(contentType);
        if (object1 instanceof Resource.Factory.Descriptor) {
            contentTypeInstance = (AbstractASResourceFactory)((Resource.Factory.Descriptor)object1).createFactory();
        } else if (object1 != null) {
            contentTypeInstance = (AbstractASResourceFactory)object1;
        } else {
            try {
                newInstance = contentTypeInstance = (AbstractASResourceFactory)resourceFactoryClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
            contentTypeToFactoryMap.put(contentType, contentTypeInstance);
        }
        Map extensionToFactoryMap = Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap();
        Object object2 = extensionToFactoryMap.get(asFileExtension);
        if (object2 instanceof Resource.Factory.Descriptor) {
            AbstractASResourceFactory extensionInstance = (AbstractASResourceFactory)((Resource.Factory.Descriptor)object2).createFactory();
        } else if (object2 != null) {
            AbstractASResourceFactory extensionInstance = (AbstractASResourceFactory)object2;
        } else if (newInstance != null) {
            AbstractASResourceFactory extensionInstance = newInstance;
        } else {
            AbstractASResourceFactory extensionInstance;
            try {
                newInstance = extensionInstance = (AbstractASResourceFactory)resourceFactoryClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
            extensionToFactoryMap.put(asFileExtension, extensionInstance);
        }
        assert (contentTypeInstance != null);
        contentTypeInstance.install(csFileExtension, null);
        assert (contentTypeInstance != null);
        return (T)contentTypeInstance;
    }

    public static void installContentHandler(int priority, @NonNull ContentHandler contentHandler) {
        ArrayList<ContentHandler> contentHandlers = (ArrayList<ContentHandler>)ContentHandler.Registry.INSTANCE.get((Object)priority);
        if (contentHandlers == null) {
            contentHandlers = new ArrayList<ContentHandler>();
            ContentHandler.Registry.INSTANCE.put((Object)priority, contentHandlers);
        }
        if (!contentHandlers.contains(contentHandler)) {
            contentHandlers.add(contentHandler);
        }
    }

    @Deprecated
    protected AbstractASResourceFactory(@NonNull String asContentType) {
        this(asContentType, null);
    }

    protected AbstractASResourceFactory(@NonNull String asContentType, @Nullable String asFileExtension) {
        this.contentType = asContentType;
        this.asFileExtension = asFileExtension;
    }

    @Override
    public @NonNull ASResourceFactory basicGetASResourceFactory() {
        return this;
    }

    @Override
    public void configure(@NonNull ResourceSet resourceSet) {
        Resource.Factory.Registry resourceFactoryRegistry = resourceSet.getResourceFactoryRegistry();
        resourceFactoryRegistry.getContentTypeToFactoryMap().put(this.contentType, this);
    }

    protected void configureASResourceSet(@NonNull ResourceSet asResourceSet, @NonNull ResourceSet csResourceSet) {
        Resource.Factory.Registry resourceFactoryRegistry = asResourceSet.getResourceFactoryRegistry();
        resourceFactoryRegistry.getContentTypeToFactoryMap().put(this.contentType, this);
        if (this.asFileExtension != null) {
            ASResourceFactory extensionASResourceFactory = this.createResourceSetAwareASResourceFactory(csResourceSet);
            if (extensionASResourceFactory == null) {
                extensionASResourceFactory = this;
            }
            resourceFactoryRegistry.getExtensionToFactoryMap().put(this.asFileExtension, extensionASResourceFactory);
        }
    }

    protected void configureCSResourceSet(@NonNull ResourceSet csResourceSet) {
        Resource.Factory.Registry resourceFactoryRegistry = csResourceSet.getResourceFactoryRegistry();
        resourceFactoryRegistry.getContentTypeToFactoryMap().put(this.contentType, this);
    }

    protected void configureResource(@NonNull ASResource asResource) {
        asResource.setEncoding("UTF-8");
        Map defaultSaveOptions = asResource.getDefaultSaveOptions();
        defaultSaveOptions.put("USE_ENCODED_ATTRIBUTE_STYLE", Boolean.TRUE);
        defaultSaveOptions.put("URI_HANDLER", new URIHandlerImpl.PlatformSchemeAware());
        defaultSaveOptions.put("SCHEMA_LOCATION", Boolean.TRUE);
        defaultSaveOptions.put("SCHEMA_LOCATION_IMPLEMENTATION", Boolean.TRUE);
        defaultSaveOptions.put("RESOURCE_ENTITY_HANDLER", new XMIUtil.IdResourceEntityHandler());
    }

    @Override
    public void configureResourceFactoryRegistry(@NonNull ResourceSet resourceSet) {
    }

    @Override
    public void configureResourceSets(@Nullable ResourceSet asResourceSet, @NonNull ResourceSet csResourceSet) {
        if (asResourceSet != null) {
            this.configureASResourceSet(asResourceSet, csResourceSet);
        }
        this.configureCSResourceSet(csResourceSet);
    }

    @Override
    public @NonNull AS2MonikerVisitor createAS2MonikerVisitor(@NonNull AS2Moniker as2moniker) {
        return new AS2MonikerVisitor(as2moniker);
    }

    @Override
    public @NonNull AS2XMIidVisitor createAS2XMIidVisitor(@NonNull AS2XMIid as2id) {
        return new AS2XMIidVisitor(as2id);
    }

    @Override
    public @NonNull ASSaverLocateVisitor createASSaverLocateVisitor(@NonNull ASSaver saver) {
        return new ASSaverLocateVisitor(saver);
    }

    @Override
    public @NonNull ASSaverNormalizeVisitor createASSaverNormalizeVisitor(@NonNull ASSaver saver) {
        return new ASSaverNormalizeVisitor(saver);
    }

    @Override
    public @NonNull ASSaverResolveVisitor createASSaverResolveVisitor(@NonNull ASSaver saver) {
        return new ASSaverResolveVisitor(saver);
    }

    @Override
    public @NonNull EnvironmentFactoryInternal createEnvironmentFactory(@NonNull ProjectManager projectManager) {
        return new PivotEnvironmentFactory(projectManager, null, null);
    }

    @Override
    public @NonNull LUSSIDs createLUSSIDs(@NonNull ASResource asResource, @NonNull Map<@NonNull Object, @Nullable Object> options) {
        return new PivotLUSSIDs(asResource, options);
    }

    @Override
    public @NonNull PrettyPrintVisitor createPrettyPrintVisitor(@NonNull PrettyPrinter prettyPrinter) {
        return new EssentialOCLPrettyPrintVisitor(prettyPrinter);
    }

    protected @Nullable ASResourceFactory createResourceSetAwareASResourceFactory(@NonNull ResourceSet csResourceSet) {
        return this;
    }

    @Override
    public @NonNull TemplateParameterSubstitutionVisitor createTemplateParameterSubstitutionVisitor(@NonNull EnvironmentFactory environmentFactory, @Nullable Type selfType, @Nullable Type selfTypeValue) {
        return new TemplateParameterSubstitutionVisitor((EnvironmentFactoryInternal)environmentFactory, selfType, selfTypeValue);
    }

    @Override
    public @NonNull ToStringVisitor createToStringVisitor(@NonNull StringBuilder s) {
        return new ToStringVisitor(s);
    }

    public Resource createResource(URI uri) {
        assert (uri != null);
        ASResourceImpl result = new ASResourceImpl(uri, this);
        this.configureResource(result);
        return result;
    }

    @Override
    public <T extends Element> @Nullable T getASElement(@NonNull EnvironmentFactoryInternal environmentFactory, @NonNull Class<T> requiredClass, @NonNull EObject eObject) throws ParserException {
        Element element;
        if (eObject instanceof Pivotable && (element = ((Pivotable)eObject).getPivot()) != null) {
            if (!requiredClass.isAssignableFrom(element.getClass())) {
                throw new ClassCastException(String.valueOf(element.getClass().getName()) + " is not assignable to " + requiredClass.getName());
            }
            Element castElement = element;
            return (T)castElement;
        }
        return null;
    }

    protected @Nullable String getASfileExtension() {
        return this.asFileExtension;
    }

    @Override
    public @NonNull ASResourceFactory getContribution() {
        return this;
    }

    @Override
    public @NonNull String getContentType() {
        return this.contentType;
    }

    @Override
    public @Nullable EOperation getEOperation(@NonNull ASResource asResource, @NonNull EObject eObject) {
        return null;
    }

    @Override
    public @Nullable EReference getEReference(@NonNull ASResource asResource, @NonNull EObject eObject) {
        return null;
    }

    @Override
    public @Nullable String getMetamodelNsURI(@NonNull EPackage ePackage) {
        return null;
    }

    @Override
    public @Nullable URI getPackageURI(@NonNull EObject eObject) {
        return null;
    }

    @Override
    public @Nullable Integer getPriority() {
        return null;
    }

    @Override
    public @Nullable String getResourceClassName() {
        return null;
    }

    @Override
    public @NonNull Technology getTechnology() {
        return EcoreTechnology.INSTANCE;
    }

    @Override
    public @Nullable Element importFromResource(@NonNull EnvironmentFactoryInternal environmentFactory, @NonNull Resource resource, @Nullable URI uri) throws ParserException {
        Object asResource = resource instanceof ASResource ? resource : ((CSResource)resource).getASResource();
        EList contents = asResource.getContents();
        if (contents.size() <= 0) {
            return null;
        }
        if (uri == null) {
            return (Element)contents.get(0);
        }
        String fragment = uri.fragment();
        if (fragment == null) {
            return (Element)contents.get(0);
        }
        EObject eObject = asResource.getEObject(fragment);
        if (eObject instanceof Element) {
            return (Element)eObject;
        }
        return null;
    }

    @Override
    public void initializeEValidatorRegistry(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull EValidator.Registry eValidatorRegistry) {
    }

    protected void install(@Nullable String nonASextension, @Nullable String resourceClassName) {
        ASResourceFactoryRegistry.INSTANCE.addASResourceFactory(this.contentType, nonASextension, resourceClassName, this);
    }

    @Override
    public boolean isCompatibleResource(@NonNull Resource newResource, @NonNull Resource oldResource) {
        return false;
    }

    public @NonNull String toString() {
        return "\u00abbasic\u00bb " + this.contentType;
    }
}

