/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.impactanalyzer.impl;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.EMFPlugin;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImpactAnalyzerPlugin
extends EMFPlugin.EclipsePlugin {
    private static ImpactAnalyzerPlugin plugin;
    public static final String DEBUG;
    public static final String EXCEPTIONS_CATCHING;
    public static final String EMPTY_STRING = "";
    private static final String SEPARATOR_SPACE = " ";
    private static final String PARENTHESIS_OPEN = "(";
    private static final String PARENTHESIS_CLOSE = ")";
    private static final String SEPARATOR_METHOD = "#";
    private static final String PREFIX_CATCHING = "CAUGHT ";
    public static final int IGNORED_EXCEPTION_WARNING = 10;
    private static boolean traceAll;

    static {
        DEBUG = String.valueOf(ImpactAnalyzerPlugin.getPluginId()) + "/debug";
        EXCEPTIONS_CATCHING = String.valueOf(DEBUG) + "/exceptions/catching";
        traceAll = Boolean.getBoolean("org.eclipse.ocl.examples.impactanalyzer.debug");
    }

    public ImpactAnalyzerPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public static ImpactAnalyzerPlugin getPlugin() {
        return plugin;
    }

    public static String getPluginId() {
        return ImpactAnalyzerPlugin.getPlugin() != null ? ImpactAnalyzerPlugin.getPlugin().getBundle().getSymbolicName() : "org.eclipse.ocl.examples.impactanalyzer";
    }

    public static void log(int severity, int code, String message, Throwable throwable) {
        String msg = message == null ? EMPTY_STRING : message;
        try {
            if (ImpactAnalyzerPlugin.getPlugin() != null) {
                ImpactAnalyzerPlugin.getPlugin().log(new Status(severity, ImpactAnalyzerPlugin.getPluginId(), code, msg, throwable));
            } else if (ImpactAnalyzerPlugin.shouldTrace(DEBUG)) {
                switch (code) {
                    case 2: {
                        System.err.print("WARNING ");
                        break;
                    }
                    case 4: 
                    case 8: {
                        System.err.print("ERROR ");
                        break;
                    }
                    default: {
                        return;
                    }
                }
                System.err.print(code);
                System.err.print(": ");
                System.err.println(message);
                if (throwable != null) {
                    throwable.printStackTrace(System.err);
                }
            }
        }
        catch (IllegalArgumentException iae) {
            ImpactAnalyzerPlugin.catching(ImpactAnalyzerPlugin.class, "log", iae);
        }
    }

    public static void catching(Class<?> clazz, String methodName, Throwable throwable) {
        if (ImpactAnalyzerPlugin.shouldTrace(EXCEPTIONS_CATCHING)) {
            ImpactAnalyzerPlugin.trace(PREFIX_CATCHING + throwable.getMessage() + SEPARATOR_SPACE + PARENTHESIS_OPEN + clazz.getName() + SEPARATOR_METHOD + methodName + PARENTHESIS_CLOSE);
            throwable.printStackTrace(System.err);
        }
    }

    public static boolean shouldTrace(String option) {
        if (ImpactAnalyzerPlugin.getPlugin() != null) {
            if (ImpactAnalyzerPlugin.getPlugin().isDebugging()) {
                return Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)option));
            }
            return false;
        }
        return traceAll || Boolean.getBoolean(option);
    }

    public static void trace(String message) {
        System.out.println("[OCL] " + message);
    }
}

