/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.vm.utils;

import java.io.IOException;
import java.io.Writer;
import java.text.MessageFormat;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.debug.vm.core.VMDebugCore;
import org.eclipse.ocl.examples.debug.vm.utils.Log;

public class WriterLog
implements Log {
    private static final String LINE_SEP = System.getProperty("line.separator");
    protected final @NonNull VMDebugCore debugCore;
    private final @NonNull Writer fWriter;
    private String fRecordSeparator;
    private boolean fFlush;
    private boolean fErrorLogged;

    public WriterLog(@NonNull VMDebugCore debugCore, @NonNull Writer writer, boolean flush) {
        this.debugCore = debugCore;
        this.fWriter = writer;
        this.fRecordSeparator = LINE_SEP;
        this.fErrorLogged = false;
        this.fFlush = flush;
    }

    protected final Writer getWriter() {
        return this.fWriter;
    }

    @Override
    public void log(int level, String message, Object param) {
        String recordStr = MessageFormat.format("Level {0} - {1}, data: {2}", level, message, String.valueOf(param));
        this.logRecord(recordStr);
    }

    @Override
    public void log(int level, String message) {
        String recordStr = MessageFormat.format("Level {0} - {1}", level, message);
        this.logRecord(recordStr);
    }

    @Override
    public void log(String message, Object param) {
        String recordStr = MessageFormat.format("{0}, data: {1}", message, String.valueOf(param));
        this.logRecord(recordStr);
    }

    @Override
    public void log(String message) {
        this.logRecord(message);
    }

    private void logRecord(String recordStr) {
        block3: {
            try {
                this.fWriter.write(recordStr);
                this.fWriter.write(this.fRecordSeparator);
                if (this.fFlush) {
                    this.fWriter.flush();
                }
            }
            catch (IOException e) {
                if (this.fErrorLogged) break block3;
                this.debugCore.error(e);
                this.fErrorLogged = true;
            }
        }
    }
}

