/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.layer.event;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.event.RowStructuralChangeEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.StructuralDiff;

public class RowInsertEvent
extends RowStructuralChangeEvent {
    public RowInsertEvent(ILayer layer, int rowPosition) {
        this(layer, new Range(rowPosition, rowPosition + 1));
    }

    public RowInsertEvent(ILayer layer, Range ... rowPositionRanges) {
        super(layer, Arrays.asList(rowPositionRanges));
    }

    public RowInsertEvent(ILayer layer, Collection<Range> rowPositionRanges) {
        super(layer, rowPositionRanges);
    }

    protected RowInsertEvent(RowInsertEvent event) {
        super(event);
    }

    @Override
    public RowInsertEvent cloneEvent() {
        return new RowInsertEvent(this);
    }

    @Override
    public Collection<StructuralDiff> getRowDiffs() {
        ArrayList<StructuralDiff> rowDiffs = new ArrayList<StructuralDiff>();
        for (Range range : this.getRowPositionRanges()) {
            rowDiffs.add(new StructuralDiff(StructuralDiff.DiffTypeEnum.ADD, new Range(range.start, range.start), range));
        }
        return rowDiffs;
    }
}

