/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.trac.core.model;

import java.util.ArrayList;
import java.util.List;

public class TracSearchFilter {
    private final String fieldName;
    private CompareOperator operator;
    private final List<String> values = new ArrayList<String>();

    public TracSearchFilter(String fieldName) {
        this.fieldName = fieldName;
    }

    public TracSearchFilter(String fieldName, CompareOperator operator, String value) {
        this(fieldName);
        this.setOperator(operator);
        this.addValue(value);
    }

    public void addValue(String value) {
        this.values.add(value);
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public CompareOperator getOperator() {
        return this.operator;
    }

    public List<String> getValues() {
        return this.values;
    }

    public void setOperator(CompareOperator operator) {
        this.operator = operator;
    }

    public static enum CompareOperator {
        CONTAINS("~"),
        CONTAINS_NOT("!~"),
        BEGINS_WITH("^"),
        NOT_BEGINS_WITH("!^"),
        ENDS_WITH("$"),
        NOT_ENDS_WITH("!$"),
        IS(""),
        IS_NOT("!");

        private String queryValue;

        public static CompareOperator fromUrl(String value) {
            CompareOperator[] compareOperatorArray = CompareOperator.values();
            int n = compareOperatorArray.length;
            int n2 = 0;
            while (n2 < n) {
                CompareOperator operator = compareOperatorArray[n2];
                if (operator != IS && operator != IS_NOT && value.startsWith(operator.queryValue)) {
                    return operator;
                }
                ++n2;
            }
            if (value.startsWith(CompareOperator.IS_NOT.queryValue)) {
                return IS_NOT;
            }
            return IS;
        }

        private CompareOperator(String queryValue) {
            this.queryValue = queryValue;
        }

        public String getQueryValue() {
            return this.queryValue;
        }

        public String toString() {
            switch (this) {
                case CONTAINS: {
                    return "contains";
                }
                case CONTAINS_NOT: {
                    return "does not contain";
                }
                case BEGINS_WITH: {
                    return "begins with";
                }
                case NOT_BEGINS_WITH: {
                    return "does not begin with";
                }
                case ENDS_WITH: {
                    return "ends with";
                }
                case NOT_ENDS_WITH: {
                    return "does not end with";
                }
                case IS_NOT: {
                    return "is not";
                }
            }
            return "is";
        }
    }
}

