/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.snapshot;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mat.snapshot.MultipleSnapshotsException;
import org.eclipse.mat.ui.Messages;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ListDialog;

public class RuntimeListDialog
extends ListDialog {
    private Button detailsButton;
    private Text detailsText;
    private Composite parent;
    private static final String NEWLINE = "\n";

    public RuntimeListDialog(Shell parent, MultipleSnapshotsException mre) {
        super(parent);
        this.setBlockOnOpen(true);
        this.setLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof MultipleSnapshotsException.Context) {
                    MultipleSnapshotsException.Context rt = (MultipleSnapshotsException.Context)element;
                    return rt.getRuntimeId();
                }
                return super.getText(element);
            }
        });
        this.setContentProvider(new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof MultipleSnapshotsException) {
                    return ((MultipleSnapshotsException)inputElement).getRuntimes().toArray();
                }
                return null;
            }
        });
        this.setInput(mre);
        this.setTitle(Messages.RuntimeSelector_SelectSnapshotTitle);
        this.setMessage(Messages.RuntimeSelector_SelectSnapshot);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.detailsButton = this.createButton(parent, 13, IDialogConstants.SHOW_DETAILS_LABEL, true);
        super.createButtonsForButtonBar(parent);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 13) {
            if (this.detailsButton.getText().equals(IDialogConstants.SHOW_DETAILS_LABEL)) {
                this.detailsButton.setText(IDialogConstants.HIDE_DETAILS_LABEL);
                Object selection = ((IStructuredSelection)this.getTableViewer().getSelection()).getFirstElement();
                if (selection instanceof MultipleSnapshotsException.Context) {
                    this.updateDetails((MultipleSnapshotsException.Context)selection);
                }
            } else {
                this.detailsButton.setText(IDialogConstants.SHOW_DETAILS_LABEL);
                this.updateDetails(null);
            }
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected Control createDialogArea(Composite container) {
        this.parent = (Composite)super.createDialogArea(container);
        this.getTableViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selected;
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection != null && (selected = selection.getFirstElement()) instanceof MultipleSnapshotsException.Context) {
                    RuntimeListDialog.this.updateDetails((MultipleSnapshotsException.Context)selected);
                }
            }
        });
        return this.parent;
    }

    private void updateDetails(MultipleSnapshotsException.Context runtime) {
        Point shellSize = this.getShell().getSize();
        Point originalContentsSize = this.getContents().computeSize(-1, -1);
        if (runtime != null && this.detailsButton.getText().equals(IDialogConstants.HIDE_DETAILS_LABEL)) {
            if (this.detailsText == null) {
                this.detailsText = new Text(this.parent, 2824);
            }
            this.detailsText.setText(this.getDetails(runtime));
            GridData data = new GridData(1808);
            data.heightHint = this.detailsText.getLineHeight() * 15;
            data.horizontalSpan = 2;
            this.detailsText.setLayoutData((Object)data);
        } else if (this.detailsText != null) {
            this.detailsText.dispose();
            this.detailsText = null;
        }
        Point newContentsSize = this.getContents().computeSize(-1, -1);
        this.getShell().setSize(new Point(shellSize.x, shellSize.y + (newContentsSize.y - originalContentsSize.y)));
    }

    private String getDetails(MultipleSnapshotsException.Context runtime) {
        StringBuffer details = new StringBuffer(200);
        details.append(MessageUtil.format((String)Messages.RuntimeSelector_Snapshot_Identifier, (Object[])new Object[]{runtime.getRuntimeId()}));
        details.append("\n\n");
        details.append(String.valueOf(Messages.RuntimeSelector_Runtime_Description) + NEWLINE);
        details.append(runtime.getDescription());
        details.append("\n\n");
        details.append(MessageUtil.format((String)Messages.RuntimeSelector_Java_Version, (Object[])new Object[]{runtime.getVersion()}));
        List options = runtime.getOptions();
        if (options != null && options.size() > 0) {
            details.append("\n\n");
            details.append(Messages.RuntimeSelector_Java_Options);
            Iterator i = options.iterator();
            while (i.hasNext()) {
                details.append(NEWLINE);
                details.append((String)i.next());
            }
        }
        return details.toString();
    }
}

