/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.snapshot;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayIntBig;
import org.eclipse.mat.snapshot.ClassHistogramRecord;
import org.eclipse.mat.snapshot.HistogramRecord;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.util.IProgressListener;

public class ClassLoaderHistogramRecord
extends HistogramRecord {
    private static final long serialVersionUID = 1L;
    protected int classLoaderId;
    private ArrayList<ClassHistogramRecord> classHistogramRecords;

    ClassLoaderHistogramRecord() {
    }

    public ClassLoaderHistogramRecord(String label, int classLoaderId, ArrayList<ClassHistogramRecord> classHistogramRecords, long numberOfObjects, long usedHeapSize, long retainedHeapSize) {
        super(label, numberOfObjects, usedHeapSize, retainedHeapSize);
        this.classLoaderId = classLoaderId;
        this.classHistogramRecords = classHistogramRecords;
    }

    public int getClassLoaderId() {
        return this.classLoaderId;
    }

    public Collection<ClassHistogramRecord> getClassHistogramRecords() {
        return this.classHistogramRecords;
    }

    public int[] getObjectIds() throws SnapshotException {
        ArrayIntBig ids = new ArrayIntBig();
        for (ClassHistogramRecord record : this.classHistogramRecords) {
            ids.addAll(record.getObjectIds());
        }
        return ids.toArray();
    }

    public long calculateRetainedSize(ISnapshot snapshot, boolean calculateIfNotAvailable, boolean approximation, IProgressListener listener) throws SnapshotException {
        if (this.retainedHeapSize > 0L || !calculateIfNotAvailable) {
            return this.retainedHeapSize;
        }
        if (this.retainedHeapSize < 0L && approximation) {
            return this.retainedHeapSize;
        }
        if (approximation) {
            this.retainedHeapSize = snapshot.getMinRetainedSize(this.getObjectIds(), listener);
            this.retainedHeapSize = -this.retainedHeapSize;
        } else {
            this.retainedHeapSize = snapshot.getHeapSize(snapshot.getRetainedSet(this.getObjectIds(), listener));
        }
        return this.retainedHeapSize;
    }

    public String toString() {
        StringBuilder summary = new StringBuilder();
        summary.append("Class Loader Histogram ");
        summary.append(this.label);
        summary.append(" [");
        summary.append(this.classLoaderId);
        summary.append("] with ");
        summary.append(this.classHistogramRecords != null ? this.classHistogramRecords.size() : 0);
        summary.append(" classes, ");
        summary.append(this.numberOfObjects);
        summary.append(" objects, ");
        summary.append(this.usedHeapSize);
        summary.append(" used heap bytes:\r\n\r\n");
        if (this.classHistogramRecords != null) {
            for (ClassHistogramRecord record : this.classHistogramRecords) {
                summary.append(record);
                summary.append("\r\n");
            }
        }
        return summary.toString();
    }
}

