/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections.threads;

import com.ibm.icu.text.DecimalFormat;
import java.math.BigInteger;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.inspections.threads.ThreadInfoImpl;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.query.Column;
import org.eclipse.mat.snapshot.extension.IThreadDetailsResolver;
import org.eclipse.mat.snapshot.extension.IThreadInfo;
import org.eclipse.mat.util.IProgressListener;

public class ThreadDetailsResolver
implements IThreadDetailsResolver {
    DecimalFormat hex = new HexFormat();
    private static final int THREAD_STATE_ALIVE = 1;
    private static final int THREAD_STATE_TERMINATED = 2;
    private static final int THREAD_STATE_RUNNABLE = 4;
    private static final int THREAD_STATE_WAITING_INDEFINITELY = 16;
    private static final int THREAD_STATE_WAITING_WITH_TIMEOUT = 32;
    private static final int THREAD_STATE_SLEEPING = 64;
    private static final int THREAD_STATE_WAITING = 128;
    private static final int THREAD_STATE_IN_OBJECT_WAIT = 256;
    private static final int THREAD_STATE_PARKED = 512;
    private static final int THREAD_STATE_BLOCKED_ON_MONITOR_ENTER = 1024;
    private static final int THREAD_STATE_SUSPENDED = 0x100000;
    private static final int THREAD_STATE_INTERRUPTED = 0x200000;
    private static final int THREAD_STATE_IN_NATIVE = 0x400000;
    private static final int THREAD_STATE_VENDOR_1 = 0x10000000;
    private static final int THREAD_STATE_VENDOR_2 = 0x20000000;
    private static final int THREAD_STATE_VENDOR_3 = 0x40000000;

    @Override
    public Column[] getColumns() {
        return new Column[]{new Column(Messages.ThreadDetailsResolver_Priority, Integer.class).noTotals(), new Column(Messages.ThreadDetailsResolver_State), new Column(Messages.ThreadDetailsResolver_State_value, Integer.class).noTotals().formatting((Format)this.hex)};
    }

    @Override
    public void complementShallow(IThreadInfo thread, IProgressListener listener) throws SnapshotException {
        Column[] cols = this.getColumns();
        Object o = thread.getThreadObject().resolveValue("priority");
        if (o instanceof Integer && thread instanceof ThreadInfoImpl && ((ThreadInfoImpl)thread).getValue(cols[0]) == null) {
            thread.setValue(cols[0], o);
        }
        if ((o = thread.getThreadObject().resolveValue("threadStatus")) instanceof Integer) {
            int state = (Integer)o;
            String stateName = this.printableState(state);
            thread.setValue(cols[1], stateName);
            thread.setValue(cols[2], state);
        }
    }

    private String printableState(int state) {
        ArrayList<String> al = new ArrayList<String>();
        if ((state & 1) != 0) {
            al.add(Messages.ThreadDetailsResolver_alive);
        }
        if ((state & 0x400) != 0) {
            al.add(Messages.ThreadDetailsResolver_blocked_on_monitor_enter);
        }
        if ((state & 0x400000) != 0) {
            al.add(Messages.ThreadDetailsResolver_in_native);
        }
        if ((state & 0x100) != 0) {
            al.add(Messages.ThreadDetailsResolver_in_object_wait);
        }
        if ((state & 0x200000) != 0) {
            al.add(Messages.ThreadDetailsResolver_interrupted);
        }
        if ((state & 0x200) != 0) {
            al.add(Messages.ThreadDetailsResolver_parked);
        }
        if ((state & 4) != 0) {
            al.add(Messages.ThreadDetailsResolver_runnable);
        }
        if ((state & 0x40) != 0) {
            al.add(Messages.ThreadDetailsResolver_sleeping);
        }
        if ((state & 0x100000) != 0) {
            al.add(Messages.ThreadDetailsResolver_suspended);
        }
        if ((state & 2) != 0) {
            al.add(Messages.ThreadDetailsResolver_terminated);
        }
        if ((state & 0x10000000) != 0) {
            al.add(Messages.ThreadDetailsResolver_vendor1);
        }
        if ((state & 0x20000000) != 0) {
            al.add(Messages.ThreadDetailsResolver_vendor2);
        }
        if ((state & 0x40000000) != 0) {
            al.add(Messages.ThreadDetailsResolver_vendor3);
        }
        if ((state & 0x80) != 0) {
            al.add(Messages.ThreadDetailsResolver_waiting);
        }
        if ((state & 0x10) != 0) {
            al.add(Messages.ThreadDetailsResolver_waiting_indefinitely);
        }
        if ((state & 0x20) != 0) {
            al.add(Messages.ThreadDetailsResolver_waiting_with_timeout);
        }
        return al.toString();
    }

    @Override
    public void complementDeep(IThreadInfo thread, IProgressListener listener) throws SnapshotException {
        this.complementShallow(thread, listener);
    }

    static class HexFormat
    extends DecimalFormat {
        private static final String JAVA_HEX_PATTERN = "[-]?(0x|0X|#)\\p{XDigit}+";
        private static final String JAVA_LONG_PATTERN = "[+-]?((0x|0X|#)(\\p{XDigit}+))|(\\p{Digit}+)";
        private static final long serialVersionUID = -420084952258370133L;

        HexFormat() {
        }

        public StringBuffer format(long val, StringBuffer buf, FieldPosition fieldPosition) {
            fieldPosition.setBeginIndex(buf.length());
            buf.append("0x").append(Long.toHexString(val));
            fieldPosition.setEndIndex(buf.length());
            return buf;
        }

        public StringBuffer format(double val, StringBuffer buf, FieldPosition fieldPosition) {
            return this.format((long)val, buf, fieldPosition);
        }

        public Number parse(String text) throws ParseException {
            if (!text.matches("[-]?(0x|0X|#)\\p{XDigit}+.*")) {
                return super.parse(text);
            }
            ParsePosition p = new ParsePosition(0);
            Number l = this.parse(text, p);
            if (l == null || p.getIndex() == 0) {
                throw new ParseException(text, 0);
            }
            return l;
        }

        public Number parse(String text, ParsePosition p) {
            if (!text.matches("[-]?(0x|0X|#)\\p{XDigit}+.*")) {
                return super.parse(text, p);
            }
            int start = p.getIndex();
            String text1 = text.substring(start).replaceFirst("(([+-]?((0x|0X|#)(\\p{XDigit}+))|(\\p{Digit}+)).*)", "$2");
            try {
                long l = Long.decode(text1);
                p.setIndex(start + text1.length());
                return l;
            }
            catch (NumberFormatException e) {
                String text2 = text1.replaceFirst(JAVA_LONG_PATTERN, "$3");
                if (text2.length() > 0) {
                    try {
                        BigInteger b1 = new BigInteger(text2, 16);
                        if (text1.startsWith("-")) {
                            b1 = b1.negate();
                        }
                        p.setIndex(start + text1.length());
                        return b1.longValue();
                    }
                    catch (NumberFormatException e2) {
                        return null;
                    }
                }
                text2 = text1.replaceFirst(JAVA_LONG_PATTERN, "$4");
                if (text2.length() > 0) {
                    try {
                        BigInteger b1 = new BigInteger(text2, 10);
                        if (text1.startsWith("-")) {
                            b1 = b1.negate();
                        }
                        p.setIndex(start + text1.length());
                        return b1.longValue();
                    }
                    catch (NumberFormatException e2) {
                        return null;
                    }
                }
                return null;
            }
        }
    }
}

