/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.common.ui.dialogs;

import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.m2m.internal.qvt.oml.common.ui.dialogs.IClassifierProvider;
import org.eclipse.m2m.internal.qvt.oml.common.ui.dialogs.Messages;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfUtil;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ui.provider.EMFProviderUtil;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class OpenClassifierDialog
extends Dialog
implements ISelectionProvider {
    private IClassifierProvider myClassifierProvider;
    private Text myQueryText;
    private TableViewer myResultsViewer;
    private ISelection mySelection = StructuredSelection.EMPTY;
    private static final String PACKAGE_SEPARATOR = " - ";

    public OpenClassifierDialog(Shell parentShell, IClassifierProvider classifierProvider) {
        super(parentShell);
        this.myClassifierProvider = classifierProvider;
    }

    public ISelection getSelection() {
        return this.mySelection;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        throw new UnsupportedOperationException();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        throw new UnsupportedOperationException();
    }

    public void setSelection(ISelection selection) {
        throw new UnsupportedOperationException();
    }

    public boolean close() {
        if (!this.myResultsViewer.getSelection().isEmpty()) {
            this.mySelection = this.myResultsViewer.getSelection();
        }
        return super.close();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setMinimumSize(500, 400);
        newShell.setText(Messages.OpenClassifierDialog_title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout(1, true));
        Label queryLabel = new Label(composite, 16384);
        queryLabel.setLayoutData((Object)new GridData(768));
        queryLabel.setText(Messages.OpenClassifierDialog_queryLabel);
        this.myQueryText = new Text(composite, 18436);
        this.myQueryText.setLayoutData((Object)new GridData(768));
        this.myQueryText.addModifyListener(this.createQueryModifyListener());
        this.myQueryText.addKeyListener(this.createQueryKeyListener());
        this.myQueryText.setFocus();
        Label resultsLabel = new Label(composite, 16384);
        resultsLabel.setLayoutData((Object)new GridData(768));
        resultsLabel.setText(Messages.OpenClassifierDialog_resultsLabel);
        this.myResultsViewer = new TableViewer(composite, 2052);
        this.myResultsViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.myResultsViewer.setContentProvider(this.createContentProvider());
        this.myResultsViewer.setLabelProvider((IBaseLabelProvider)this.createLabelProvider());
        this.myResultsViewer.addOpenListener(this.createOpenListener());
        return composite;
    }

    protected IContentProvider createContentProvider() {
        return new IStructuredContentProvider(){
            private final Object[] EMPTY_ARRAY = new Object[0];

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof EClassifier[]) {
                    return (EClassifier[])inputElement;
                }
                return this.EMPTY_ARRAY;
            }
        };
    }

    protected ILabelProvider createLabelProvider() {
        final ILabelProvider provider = EMFProviderUtil.createLabelProvider();
        return new ILabelProvider(){

            public Image getImage(Object element) {
                return provider.getImage(element);
            }

            public String getText(Object element) {
                if (element instanceof EClassifier) {
                    EClassifier classifier = (EClassifier)element;
                    return String.valueOf(classifier.getName()) + OpenClassifierDialog.PACKAGE_SEPARATOR + EmfUtil.getFullName((EClassifier)classifier);
                }
                return null;
            }

            public void addListener(ILabelProviderListener listener) {
                provider.addListener(listener);
            }

            public void dispose() {
                provider.dispose();
            }

            public boolean isLabelProperty(Object element, String property) {
                return provider.isLabelProperty(element, property);
            }

            public void removeListener(ILabelProviderListener listener) {
                provider.removeListener(listener);
            }
        };
    }

    protected IOpenListener createOpenListener() {
        return new IOpenListener(){

            public void open(OpenEvent event) {
                if (!OpenClassifierDialog.this.myResultsViewer.getSelection().isEmpty()) {
                    OpenClassifierDialog.this.okPressed();
                }
            }
        };
    }

    protected KeyListener createQueryKeyListener() {
        return new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    OpenClassifierDialog.this.myResultsViewer.getControl().setFocus();
                }
            }
        };
    }

    protected ModifyListener createQueryModifyListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                OpenClassifierDialog.this.updateResults();
            }
        };
    }

    protected void updateResults() {
        EClassifier[] classifiers = this.myClassifierProvider.getClassifiers(this.myQueryText.getText());
        this.myResultsViewer.setInput((Object)classifiers);
        if (classifiers.length > 0) {
            this.myResultsViewer.setSelection((ISelection)new StructuredSelection((Object)classifiers[0]));
        }
    }

    protected Text getQueryText() {
        return this.myQueryText;
    }

    protected TableViewer getResultsViewer() {
        return this.myResultsViewer;
    }
}

