/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.dsls.tcs.injector;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.m2m.atl.dsls.tcs.injector.ModelAdapter;
import org.eclipse.m2m.atl.dsls.tcs.injector.TCSRuntime;
import org.eclipse.m2m.atl.dsls.tcs.injector.wrappers.ParserWrapper;

public class ParserLauncher {
    private static final int DEFAULT_TAB_SIZE = 8;
    private List refSettings;
    private ParserWrapper parserWrapper;

    public Object parse(ModelAdapter target, Reader in, Map arguments) throws IOException {
        Object ret = null;
        this.refSettings = new ArrayList();
        int tabSize = arguments.get("tabSize") == null ? 8 : Integer.parseInt((String)arguments.get("tabSize"));
        String parserGeneratorClassName = (String)arguments.get("parserGenerator");
        if (parserGeneratorClassName != null) {
            try {
                this.parserWrapper = (ParserWrapper)Class.forName("org.eclipse.m2m.atl.dsls.tcs.injector.wrappers." + parserGeneratorClassName + ".ParserWrapper", true, Thread.currentThread().getContextClassLoader()).newInstance();
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException("Unable to instanciate parser generator with name " + parserGeneratorClassName);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Unable to access to parser generator with name " + parserGeneratorClassName);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Unable to locate parser generator with name " + parserGeneratorClassName);
            }
        } else {
            this.parserWrapper = new org.eclipse.m2m.atl.dsls.tcs.injector.wrappers.antlr3.ParserWrapper();
        }
        String nameAndProductionRule = (String)arguments.get("name");
        String[] ss = nameAndProductionRule.split("-");
        String name = ss[0];
        String productionRule = "main";
        if (ss.length > 1) {
            productionRule = ss[1];
        }
        TCSRuntime runtime = new TCSRuntime(target, this.parserWrapper, this.refSettings, arguments);
        this.parserWrapper.setRuntime(runtime);
        try {
            ret = this.parserWrapper.parse(tabSize, name, productionRule, in, arguments);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Collections.sort(this.refSettings, new Comparator(){

            public int compare(Object o1, Object o2) {
                TCSRuntime.RefSetting rs1 = (TCSRuntime.RefSetting)o1;
                TCSRuntime.RefSetting rs2 = (TCSRuntime.RefSetting)o2;
                if (rs1.importContext && !rs2.importContext) {
                    return -1;
                }
                if (rs2.importContext && !rs1.importContext) {
                    return 1;
                }
                return 0;
            }
        });
        int nbCrashedRefSettings = 0;
        Iterator i = this.refSettings.iterator();
        while (i.hasNext()) {
            TCSRuntime.RefSetting rs = (TCSRuntime.RefSetting)i.next();
            try {
                rs.doIt();
            }
            catch (Exception e) {
                ++nbCrashedRefSettings;
            }
        }
        if (nbCrashedRefSettings > 0) {
            throw new IOException("Warning: " + nbCrashedRefSettings + " refSetting crashed");
        }
        return ret;
    }
}

