/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.core.ui.launch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.m2m.atl.core.ui.ATLCoreUIPlugin;
import org.eclipse.m2m.atl.core.ui.Messages;
import org.eclipse.m2m.atl.engine.parser.AtlSourceManager;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ATLLaunchShortcut
implements ILaunchShortcut {
    public void launch(ISelection selection, String mode) {
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        IFile file = (IFile)structuredSelection.getFirstElement();
        this.launch(file, mode);
    }

    public void launch(IEditorPart editor, String mode) {
        IFile file = ((IFileEditorInput)editor.getEditorInput()).getFile();
        this.launch(file, mode);
    }

    protected void launch(IFile file, String mode) {
        ArrayList<ILaunchConfiguration> availableConfigurations = new ArrayList<ILaunchConfiguration>();
        try {
            ILaunchConfiguration configuration;
            ILaunchConfiguration[] configurations;
            ILaunchConfiguration[] iLaunchConfigurationArray = configurations = this.getLaunchManager().getLaunchConfigurations(this.getConfigurationType());
            int n = configurations.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration launchConfiguration = iLaunchConfigurationArray[n2];
                String moduleName = launchConfiguration.getAttribute("ATL File Name", "");
                if (moduleName.endsWith(".atl")) {
                    if (file.getFullPath().toString().equals(moduleName)) {
                        availableConfigurations.add(launchConfiguration);
                    }
                } else if (moduleName.endsWith(".asm")) {
                    moduleName = String.valueOf(moduleName.substring(0, moduleName.length() - 4)) + ".atl";
                    if (file.getFullPath().toString().equals(moduleName)) {
                        availableConfigurations.add(launchConfiguration);
                    }
                }
                ++n2;
            }
            if (availableConfigurations.size() == 1) {
                DebugUITools.launch((ILaunchConfiguration)((ILaunchConfiguration)availableConfigurations.get(0)), (String)mode);
                return;
            }
            if (!availableConfigurations.isEmpty()) {
                configuration = this.chooseConfiguration(availableConfigurations);
                if (configuration != null) {
                    DebugUITools.launch((ILaunchConfiguration)configuration, (String)mode);
                }
                return;
            }
            if (this.isLaunchable(file)) {
                configuration = this.createConfiguration(file);
                ILaunchGroup group = DebugUITools.getLaunchGroup((ILaunchConfiguration)configuration, (String)mode);
                if (DebugUITools.openLaunchConfigurationDialog((Shell)ATLCoreUIPlugin.getDefault().getShell(), (ILaunchConfiguration)configuration, (String)group.getIdentifier(), (IStatus)Status.OK_STATUS) != 1) {
                    configuration.doSave();
                }
            }
        }
        catch (CoreException e) {
            MessageDialog.openError((Shell)ATLCoreUIPlugin.getDefault().getShell(), (String)Messages.getString("ATLLaunchShortcut.LAUNCH_ERROR"), (String)e.getMessage());
        }
    }

    private boolean isLaunchable(IFile file) throws CoreException {
        try {
            AtlSourceManager sourceManager = new AtlSourceManager();
            sourceManager.updateDataSource(file.getContents());
            int atlFileType = sourceManager.getATLFileType();
            return atlFileType == 1 || atlFileType == 3;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    protected ILaunchConfiguration chooseConfiguration(List<ILaunchConfiguration> configList) {
        IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(ATLCoreUIPlugin.getDefault().getShell(), (ILabelProvider)labelProvider);
        dialog.setElements(configList.toArray());
        dialog.setTitle(Messages.getString("ATLLaunchShortcut.SELECT_TRANSFO"));
        dialog.setMessage(Messages.getString("ATLLaunchShortcut.SELECT_EXISTING"));
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        labelProvider.dispose();
        if (result == 0) {
            return (ILaunchConfiguration)dialog.getFirstResult();
        }
        return null;
    }

    private ILaunchConfigurationWorkingCopy createConfiguration(IFile file) throws CoreException {
        String name = this.getLaunchManager().generateUniqueLaunchConfigurationNameFrom(this.getModuleNameFromFile(file));
        ILaunchConfigurationWorkingCopy wc = this.getConfigurationType().newInstance(null, name);
        wc.setAttribute("ATL File Name", file.getFullPath().toString());
        return wc;
    }

    public String getModuleNameFromFile(IFile file) {
        String fileName = file.getName();
        if (fileName.endsWith(".atl")) {
            fileName = fileName.substring(0, fileName.length() - 4);
        }
        return fileName;
    }

    protected ILaunchConfigurationType getConfigurationType() {
        return this.getLaunchManager().getLaunchConfigurationType("org.eclipse.m2m.atl.adt.launching.atlTransformation");
    }

    private ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }
}

