/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jst.j2ee.project.facet.IJ2EEFacetConstants;
import org.eclipse.m2e.core.internal.markers.SourceLocation;
import org.eclipse.m2e.core.internal.markers.SourceLocationHelper;
import org.eclipse.m2e.wtp.AbstractFilteringSupportMavenPlugin;
import org.eclipse.m2e.wtp.DomUtils;
import org.eclipse.m2e.wtp.IMavenPackageFilter;
import org.eclipse.m2e.wtp.JEEPackaging;
import org.eclipse.m2e.wtp.earmodules.ArtifactTypeMappingService;
import org.eclipse.m2e.wtp.earmodules.EarModule;
import org.eclipse.m2e.wtp.earmodules.EarModuleFactory;
import org.eclipse.m2e.wtp.earmodules.EarPluginException;
import org.eclipse.m2e.wtp.earmodules.SecurityRoleKey;
import org.eclipse.m2e.wtp.internal.Messages;
import org.eclipse.m2e.wtp.namemapping.AbstractFileNameMapping;
import org.eclipse.m2e.wtp.namemapping.FileNameMapping;
import org.eclipse.m2e.wtp.namemapping.FileNameMappingFactory;
import org.eclipse.m2e.wtp.namemapping.PatternBasedFileNameMapping;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EarPluginConfiguration
extends AbstractFilteringSupportMavenPlugin
implements IMavenPackageFilter {
    private static final Logger LOG = LoggerFactory.getLogger(EarPluginConfiguration.class);
    private static final String EAR_DEFAULT_BUNDLE_DIR = "/";
    private static final String EAR_DEFAULT_CONTENT_DIR = "src/main/application";
    private static final IProjectFacetVersion DEFAULT_EAR_FACET = IJ2EEFacetConstants.ENTERPRISE_APPLICATION_13;
    private final MavenProject mavenProject;
    private String libDirectory;
    private ArtifactTypeMappingService typeMappingService;
    private Set<EarModule> earModules;
    private boolean supportsUseBaseVersion = false;

    public EarPluginConfiguration(MavenProject mavenProject) {
        if (JEEPackaging.EAR != JEEPackaging.getValue(mavenProject.getPackaging())) {
            throw new IllegalArgumentException(Messages.EarPluginConfiguration_Project_Must_Have_ear_Packaging);
        }
        this.mavenProject = mavenProject;
        Plugin plugin = this.getPlugin();
        try {
            VersionRange ear_2_9 = VersionRange.createFromVersionSpec((String)"[2.9,)");
            if (ear_2_9.containsVersion((ArtifactVersion)new DefaultArtifactVersion(plugin.getVersion()))) {
                this.supportsUseBaseVersion = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setConfiguration((Xpp3Dom)plugin.getConfiguration());
    }

    public Plugin getPlugin() {
        return this.mavenProject.getPlugin("org.apache.maven.plugins:maven-ear-plugin");
    }

    public IProjectFacetVersion getEarFacetVersion() {
        Xpp3Dom config = this.getConfiguration();
        if (config == null) {
            return DEFAULT_EAR_FACET;
        }
        Xpp3Dom domVersion = config.getChild("version");
        if (domVersion != null) {
            String sVersion = domVersion.getValue();
            try {
                double version = Double.parseDouble(sVersion);
                sVersion = Double.toString(version);
                try {
                    return IJ2EEFacetConstants.ENTERPRISE_APPLICATION_FACET.getVersion(sVersion);
                }
                catch (Exception e) {
                    LOG.warn(e.getMessage());
                    if (version > 5.0) {
                        return IJ2EEFacetConstants.ENTERPRISE_APPLICATION_FACET.getVersion("5.0");
                    }
                }
            }
            catch (NumberFormatException nfe) {
                LOG.error(NLS.bind((String)Messages.EarPluginConfiguration_Error_Reading_EAR_Version, (Object)sVersion), (Throwable)nfe);
                return DEFAULT_EAR_FACET;
            }
        }
        return DEFAULT_EAR_FACET;
    }

    public String getEarContentDirectory(IProject project) {
        Xpp3Dom contentDirDom;
        Xpp3Dom config = this.getConfiguration();
        if (config != null && (contentDirDom = config.getChild("earSourceDirectory")) != null && contentDirDom.getValue() != null) {
            String projectLocation;
            IPath projectLocationPath;
            String contentDir = contentDirDom.getValue().trim();
            if (project != null && (projectLocationPath = project.getLocation()) != null && contentDir.startsWith(projectLocation = projectLocationPath.toOSString())) {
                return contentDir.substring(projectLocation.length());
            }
            contentDir = contentDir.length() == 0 ? EAR_DEFAULT_CONTENT_DIR : contentDir;
            return contentDir;
        }
        return EAR_DEFAULT_CONTENT_DIR;
    }

    public String getDefaultBundleDirectory() {
        if (this.libDirectory == null) {
            Xpp3Dom libDom;
            Xpp3Dom config = this.getConfiguration();
            if (config != null && (libDom = config.getChild("defaultLibBundleDir")) != null && libDom.getValue() != null) {
                String libDir = libDom.getValue().trim();
                this.libDirectory = libDir.length() == 0 ? EAR_DEFAULT_BUNDLE_DIR : libDir;
            }
            this.libDirectory = this.libDirectory == null ? EAR_DEFAULT_BUNDLE_DIR : this.libDirectory;
        }
        return this.libDirectory;
    }

    public Set<EarModule> getEarModules() throws EarPluginException {
        if (this.earModules == null) {
            this.earModules = this.collectEarModules();
            Iterator<EarModule> modulesIterator = this.earModules.iterator();
            while (modulesIterator.hasNext()) {
                EarModule module = modulesIterator.next();
                if (!module.isExcluded()) continue;
                modulesIterator.remove();
            }
            this.earModules = Collections.unmodifiableSet(this.earModules);
        }
        return this.earModules;
    }

    public Set<EarModule> getAllEarModules() throws EarPluginException {
        return Collections.unmodifiableSet(this.collectEarModules());
    }

    private Set<EarModule> collectEarModules() throws EarPluginException {
        Set artifacts = this.mavenProject.getArtifacts();
        if (artifacts == null || artifacts.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<EarModule> earModules = new LinkedHashSet<EarModule>(artifacts.size());
        String defaultBundleDir = this.getDefaultBundleDirectory();
        IProjectFacetVersion javaEEVersion = this.getEarFacetVersion();
        EarModuleFactory earModuleFactory = EarModuleFactory.createEarModuleFactory(this.getArtifactTypeMappingService(), this.getFileNameMapping(), this.getMainArtifactId(), artifacts);
        earModules.addAll(this.getEarModulesFromConfig(earModuleFactory, defaultBundleDir, javaEEVersion));
        ScopeArtifactFilter filter = new ScopeArtifactFilter("runtime");
        for (Artifact artifact : artifacts) {
            EarModule module;
            if ("pom".equals(artifact.getType())) continue;
            boolean isIncludedInApplicationXml = this.isIncludeLibInApplicationXml();
            if (EarPluginConfiguration.isArtifactRegistered(artifact, earModules) || !filter.include(artifact) || artifact.isOptional() || (module = earModuleFactory.newEarModule(artifact, defaultBundleDir, javaEEVersion, isIncludedInApplicationXml)) == null) continue;
            earModules.add(module);
        }
        return earModules;
    }

    private String getMainArtifactId() {
        return "none";
    }

    private ArtifactTypeMappingService getArtifactTypeMappingService() throws EarPluginException {
        if (this.typeMappingService == null) {
            Xpp3Dom config = this.getConfiguration();
            Xpp3Dom artifactTypeMappingConfig = null;
            if (config != null) {
                artifactTypeMappingConfig = config.getChild("artifactTypeMappings");
            }
            this.typeMappingService = new ArtifactTypeMappingService(artifactTypeMappingConfig);
        }
        return this.typeMappingService;
    }

    private FileNameMapping getFileNameMapping() {
        boolean useBaseVersion;
        Xpp3Dom config = this.getConfiguration();
        FileNameMapping mapping = null;
        boolean bl = useBaseVersion = !this.supportsUseBaseVersion;
        if (config != null) {
            Xpp3Dom outputFileNameMappingDom = config.getChild("outputFileNameMapping");
            if (outputFileNameMappingDom != null) {
                String pattern = outputFileNameMappingDom.getValue().trim();
                mapping = new PatternBasedFileNameMapping(pattern);
            } else {
                Xpp3Dom fileNameMappingDom = config.getChild("fileNameMapping");
                if (fileNameMappingDom != null) {
                    String fileNameMappingName = fileNameMappingDom.getValue().trim();
                    mapping = FileNameMappingFactory.getFileNameMapping(fileNameMappingName);
                }
                if (this.supportsUseBaseVersion) {
                    useBaseVersion = DomUtils.getBooleanChildValue(config, "useBaseVersion", false);
                }
            }
        }
        if (mapping == null) {
            mapping = FileNameMappingFactory.getDefaultFileNameMapping();
        }
        if (mapping instanceof AbstractFileNameMapping) {
            ((AbstractFileNameMapping)mapping).setUseBaseVersion(useBaseVersion);
        }
        return mapping;
    }

    private Set<EarModule> getEarModulesFromConfig(EarModuleFactory earModuleFactory, String defaultBundleDir, IProjectFacetVersion javaEEVersion) throws EarPluginException {
        LinkedHashSet<EarModule> earModules = new LinkedHashSet<EarModule>();
        Xpp3Dom configuration = this.getConfiguration();
        if (configuration == null) {
            return earModules;
        }
        Xpp3Dom modulesNode = configuration.getChild("modules");
        if (modulesNode == null) {
            return earModules;
        }
        Xpp3Dom[] domModules = modulesNode.getChildren();
        if (domModules == null || domModules.length == 0) {
            return earModules;
        }
        boolean isIncludedInApplicationXml = this.isIncludeLibInApplicationXml();
        Xpp3Dom[] xpp3DomArray = domModules;
        int n = domModules.length;
        int n2 = 0;
        while (n2 < n) {
            Xpp3Dom domModule = xpp3DomArray[n2];
            EarModule earModule = earModuleFactory.newEarModule(domModule, defaultBundleDir, javaEEVersion, isIncludedInApplicationXml);
            if (earModule != null) {
                earModules.add(earModule);
            }
            ++n2;
        }
        return earModules;
    }

    private static boolean isArtifactRegistered(Artifact a, Set<EarModule> modules) {
        for (EarModule module : modules) {
            if (!module.getArtifact().equals(a)) continue;
            return true;
        }
        return false;
    }

    public boolean isGenerateApplicationXml() {
        Xpp3Dom configuration = this.getConfiguration();
        if (configuration == null) {
            return true;
        }
        Xpp3Dom generateApplicationXmlNode = configuration.getChild("generateApplicationXml");
        return generateApplicationXmlNode == null || Boolean.parseBoolean(generateApplicationXmlNode.getValue());
    }

    public Set<SecurityRoleKey> getSecurityRoleKeys() {
        HashSet<SecurityRoleKey> securityRoles = new HashSet<SecurityRoleKey>();
        Xpp3Dom configuration = this.getConfiguration();
        if (configuration == null) {
            return securityRoles;
        }
        Xpp3Dom securityNode = configuration.getChild("security");
        if (securityNode == null) {
            return securityRoles;
        }
        Xpp3Dom[] secRoles = securityNode.getChildren("security-role");
        if (secRoles == null || secRoles.length == 0) {
            return securityRoles;
        }
        Xpp3Dom[] xpp3DomArray = secRoles;
        int n = secRoles.length;
        int n2 = 0;
        while (n2 < n) {
            Xpp3Dom domSecRole = xpp3DomArray[n2];
            String id = domSecRole.getAttribute("id");
            String description = DomUtils.getChildValue(domSecRole, "description");
            String roleName = DomUtils.getChildValue(domSecRole, "role-name");
            if (roleName != null) {
                SecurityRoleKey srk = new SecurityRoleKey();
                srk.setId(id);
                srk.setRoleName(roleName);
                srk.setDescription(description);
                securityRoles.add(srk);
            }
            ++n2;
        }
        return securityRoles;
    }

    @Override
    protected String getFilteringAttribute() {
        return "filtering";
    }

    public boolean isIncludeLibInApplicationXml() {
        Xpp3Dom configuration = this.getConfiguration();
        if (configuration == null) {
            return false;
        }
        boolean isIncluded = DomUtils.getBooleanChildValue(configuration, "includeLibInApplicationXml");
        return isIncluded;
    }

    @Override
    public String[] getPackagingExcludes() {
        return DomUtils.getPatternsAsArray(this.getConfiguration(), "packagingExcludes");
    }

    @Override
    public String[] getPackagingIncludes() {
        return DomUtils.getPatternsAsArray(this.getConfiguration(), "packagingIncludes");
    }

    @Override
    public String[] getSourceExcludes() {
        return DomUtils.getPatternsAsArray(this.getConfiguration(), "earSourceExcludes");
    }

    @Override
    public String[] getSourceIncludes() {
        return DomUtils.getPatternsAsArray(this.getConfiguration(), "earSourceIncludes");
    }

    @Override
    public SourceLocation getSourceLocation() {
        Plugin plugin = this.getPlugin();
        if (plugin == null) {
            return null;
        }
        return SourceLocationHelper.findLocation((Plugin)plugin, (String)"configuration");
    }

    @Override
    public String getSourceIncludeParameterName() {
        return "earSourceIncludes";
    }

    public String getFinalName() {
        String finalName = DomUtils.getChildValue(this.getConfiguration(), "finalName");
        if (StringUtils.isEmpty((String)finalName)) {
            finalName = this.mavenProject.getBuild().getFinalName();
        }
        return finalName;
    }
}

