/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.logback.appender;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class EclipseLogAppender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    private static final String BUNDLE_ID = "org.eclipse.m2e.logback.appender";
    private static final ILog ECLIPSE_LOG = Platform.getLog(EclipseLogAppender.class);

    protected void append(ILoggingEvent logEvent) {
        int severity;
        switch (logEvent.getLevel().levelInt) {
            case 40000: {
                severity = 4;
                break;
            }
            case 30000: {
                severity = 2;
                break;
            }
            case 20000: {
                severity = 1;
                break;
            }
            default: {
                return;
            }
        }
        Status status = new Status(severity, BUNDLE_ID, logEvent.getFormattedMessage(), EclipseLogAppender.getThrowable(logEvent));
        ECLIPSE_LOG.log((IStatus)status);
    }

    private static Throwable getThrowable(ILoggingEvent logEvent) {
        if (logEvent.getThrowableProxy() instanceof ThrowableProxy) {
            return ((ThrowableProxy)logEvent.getThrowableProxy()).getThrowable();
        }
        Object[] args = logEvent.getArgumentArray();
        if (args != null && args.length > 0 && args[args.length - 1] instanceof Throwable) {
            return (Throwable)args[args.length - 1];
        }
        return null;
    }
}

