/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.lifecyclemapping.discovery;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.eclipse.m2e.core.internal.lifecyclemapping.discovery.MojoExecutionMappingConfiguration;
import org.eclipse.m2e.core.internal.lifecyclemapping.discovery.PackagingTypeMappingConfiguration;

public class ProjectLifecycleMappingConfiguration {
    private final String relpath;
    private final List<MojoExecutionMappingConfiguration> mojoExecutionConfigurations = new ArrayList<MojoExecutionMappingConfiguration>();
    private final MavenProject mavenProject;
    private final PackagingTypeMappingConfiguration configuration;
    private final List<MojoExecution> mojoExecutions;

    public ProjectLifecycleMappingConfiguration(String relpath, MavenProject project, List<MojoExecution> mojoExecutions, PackagingTypeMappingConfiguration configuration) {
        this.relpath = relpath;
        this.mavenProject = project;
        this.mojoExecutions = mojoExecutions;
        this.configuration = configuration;
    }

    public String getRelpath() {
        return this.relpath;
    }

    public PackagingTypeMappingConfiguration getPackagingTypeMappingConfiguration() {
        return this.configuration;
    }

    public List<MojoExecutionMappingConfiguration> getMojoExecutionConfigurations() {
        return this.mojoExecutionConfigurations;
    }

    public void addMojoExecution(MojoExecutionMappingConfiguration configuration) {
        this.mojoExecutionConfigurations.add(configuration);
    }

    public String getMavenText() {
        return String.valueOf(this.relpath) + " artifactId=" + this.mavenProject.getArtifactId() + " packaging=" + this.mavenProject.getPackaging();
    }

    public MavenProject getMavenProject() {
        return this.mavenProject;
    }

    public List<MojoExecution> getMojoExecutions() {
        return this.mojoExecutions;
    }
}

